// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// 
/// @file
/// @author  Marek Kurdej <firstname.surname@utc.fr>
/// @date    March, 2012
/// @version $Id: Log.h 66 2013-01-09 16:54:11Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Logging facility.
///
/// Detailed description.

#ifndef DEF_PACPUS_LOG_H
#define DEF_PACPUS_LOG_H

// Includes, pacpus.
#include <Pacpus/kernel/pacpus.h>

namespace pacpus {

static class PACPUSLIB_API LogConfigurator
{
public:
    LogConfigurator();
    ~LogConfigurator();

    static void configureLoggerWithFile(const char * configFilename);
} initializer; // using Schwarz/nifty counter idiom for static initialization

} // namespace pacpus

#ifdef PACPUS_USE_LOG
  // Includes, log4cxx.
  #include <log4cxx/logger.h>

  class QString;

  /** Declare a log4cxx logger
   * @param name Name of the logger, displayed when logging a message.
   */
  #define DECLARE_STATIC_LOGGER(name) \
    static log4cxx::LoggerPtr logger(log4cxx::Logger::getLogger(name))

  // Macros making logging user friendly.
  #define LOG_TRACE(message)          LOG4CXX_TRACE(logger, message)
  #define LOG_DEBUG(message)          LOG4CXX_DEBUG(logger, message)
  #define LOG_INFO(message)           LOG4CXX_INFO(logger, message)
  #define LOG_WARN(message)           LOG4CXX_WARN(logger, message)
  #define LOG_ERROR(message)          LOG4CXX_ERROR(logger, message)
  #define LOG_FATAL(message)          LOG4CXX_FATAL(logger, message)

  // Provides helpers to log a QString.
  PACPUSLIB_API ::log4cxx::helpers::CharMessageBuffer & operator<<(::log4cxx::helpers::CharMessageBuffer & os, const QString & s);
  PACPUSLIB_API ::log4cxx::helpers::CharMessageBuffer & operator<<(::log4cxx::helpers::MessageBuffer & os, const QString & s);
#else
  #define DECLARE_STATIC_LOGGER(name)
  #define LOG_TRACE(message)
  #define LOG_DEBUG(message)
  #define LOG_INFO(message)
  #define LOG_WARN(message)
  #define LOG_ERROR(message)
  #define LOG_FATAL(message)
#endif // PACPUS_USE_LOG

#endif // DEF_PACPUS_LOG_H
