// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// 
/// @file
/// @author  Firstname Surname <firstname.surname@utc.fr>
/// @date    Month, Year
/// @version $Id: ShMem.h 66 2013-01-09 16:54:11Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Detailed description.

#ifndef DEF_PACPUS_SHMEM_H
#define DEF_PACPUS_SHMEM_H

#ifdef WIN32
#   include "Win32ShMem.h"
#   define ShMemType Win32ShMem
#else
#   include "PosixShMem.h"
#   define ShMemType PosixShMem
#endif

namespace pacpus {

class ShMem
        : public ShMemType
{
public:
    ShMem(const char * name, int size)
        : ShMemType(name, size)
    {
    }

    ~ShMem()
    {
    }

protected:
private:
};

} // namespace pacpus

#endif // DEF_PACPUS_SHMEM_H
