// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// 
/// @file
/// @author  Firstname Surname <firstname.surname@utc.fr>
/// @date    Month, Year
/// @version $Id: PosixShMem.h 66 2013-01-09 16:54:11Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Detailed description.

#ifndef DEF_PACPUS_POSIXSHMEM_H
#define DEF_PACPUS_POSIXSHMEM_H

#include <QSharedMemory>
#include <QSystemSemaphore>

#include <Pacpus/PacpusTools/ShMemBase.h>

class PosixShMem
        : public ShMemBase
{
public:
    PosixShMem(const char * name, int size);
    virtual ~PosixShMem();

    virtual void *read();
    virtual void write(void *data, int size, unsigned long offset = 0);
    virtual bool wait(unsigned long timeout = 0);
    virtual void lockMemory();
    virtual void unlockMemory();

private:
    QSystemSemaphore * event_;
    QSharedMemory * memory_;
};

#endif // DEF_PACPUS_POSIXSHMEM_H
