// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// 
/// @file
/// @author  Gerald Dherbomez <firstname.surname@utc.fr>
/// @date    January, 2007
/// @version $Id: Win32ShMem.h 66 2013-01-09 16:54:11Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Shared memory implementation for Windows.
///
/// Shared memory implementation for Windows.
/// @todo Derive from a common base class. Same for @link PosixShMem.

#ifndef DEF_PACPUS_WIN32SHMEM_H
#define DEF_PACPUS_WIN32SHMEM_H

#include <Pacpus/PacpusTools/ShMemBase.h>

typedef void * HANDLE;

class Win32ShMem
        : public ShMemBase
{
public:
    Win32ShMem(const char * name, int size);
    ~Win32ShMem();

    virtual bool wait(unsigned long timeout = 0);
    virtual void * read();
    virtual void read(void * mem, int size);
    virtual void write(void * data, int size, unsigned long offset = 0);
    virtual void lockMemory();
    virtual void unlockMemory();
    virtual void * getEventIdentifier();

protected:  

private:
    HANDLE semaphore_;
    HANDLE shMemHandle_;
    HANDLE event_;
};

#endif // DEF_PACPUS_WIN32SHMEM_H
