// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// 
/// @file
/// @author  Firstname Surname <firstname.surname@utc.fr>
/// @date    Month, Year
/// @version $Id: ShMem.h 67 2013-01-09 18:17:44Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Detailed description.

#ifndef DEF_PACPUS_SHMEM_H
#define DEF_PACPUS_SHMEM_H

#ifdef WIN32
#   include "Win32ShMem.h"
#   define ShMemType Win32ShMem
#else
#   include "PosixShMem.h"
#   define ShMemType PosixShMem
#endif

namespace pacpus {

class ShMem
        : public ShMemType
{
public:
    /// @brief Ctor of shared memory class.
    ///
    /// Creates a shared memory of size @b size and named @b name.
    /// If a shared memory with the name @b name already exists, than
    /// it will return object pointing to the same memory.
    /// If this existing memory space has a size smaller than @b size,
    /// a warning will be issued.
    ///
    /// @param name Name of the created shared memory space.
    /// @param size Size of the created shared memory space in [bytes].
    ShMem(const char * name, int size)
        : ShMemType(name, size)
    {
    }

    /// @brief Dtor of shared memory class.
    ///
    /// Does nothing.
    ~ShMem()
    {
    }

protected:
private:
};

} // namespace pacpus

#endif // DEF_PACPUS_SHMEM_H
