// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// 
/// @file
/// @author  Firstname Surname <firstname.surname@utc.fr>
/// @date    Month, Year
/// @version $Id: matrice.h 69 2013-01-09 23:04:42Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Matrix algebra functions.
///
/// Detailed description.

#ifndef MATRIX_H
#define MATRIX_H

typedef enum
{
    ONES,
    ZEROS,
    IDENTITY
} t_m;

/// Simple matrix.
/// @todo Documentation
class matrice
{
    typedef double *ligne;
    ligne *lignes;
    unsigned short int n;   // Nombre de lignes (1erparamètre).
    unsigned short int m;   // Nombre de colonnes (2èmeparamètre).

public:
    /// Ctor
    matrice();
    /// Ctor
    matrice(unsigned short int nl, unsigned short int nc);
    /// Ctor
    matrice(unsigned short int nl, unsigned short int nc,t_m type);
    /// Copy ctor
    matrice(const matrice &source); //constructeur par copie
    /// Dtor
    virtual ~matrice(void);

    /// Allocates matrix data
    /// @todo Rename
    void Alloue(unsigned short int nl, unsigned short int nc);

    /// Assignment operator for matrix operand
    matrice &operator=(const matrice &m);//m=m1
    /// Assignment operator for scalar operand
    matrice &operator=(double x); //m=x
    /// Conversion operator to double
    /// @todo FIXME
    operator double() const
    {
        return **lignes;
    }

    matrice &operator+=(const matrice &m); //m+=m1
    matrice &operator-=(const matrice &m); //m-=m1

    matrice operator+(const matrice &m1) const; //m=m1+m2
    matrice operator-(const matrice &m1) const; //m=m1-m2
    matrice operator*(const matrice &m1) const; //m=m1*m2

    matrice &operator+=(double x); //m+=x
    matrice &operator-=(double x); //m-=x

    matrice operator+(double x)const; //m+x
    matrice operator-(double x)const; //m-x
    matrice operator*(double x)const; //m*x
    matrice operator/(double x)const; //m/x

    friend matrice operator+(double x,matrice m1) {return m1+x ;} // x+m ;
    friend matrice operator-(double x,matrice m1) {return m1-x ;} // x-m ;
    friend matrice operator*(double x,matrice m1) {return m1*x ;} // x*m ;

    matrice T(); //transposition
    matrice I(); //inversion

    double &operator()(unsigned short int i, unsigned short int j); // ecriture m(i,j)=x
    double operator()(unsigned short int i, unsigned short int j) const; //lecture x=m(i,j)
    double &operator()(unsigned short int i); // ecriture m(i)=x
    double operator()(unsigned short int i) const; //lecture x=m(i)

    void print(const char *nom);
};

#endif // MATRIX_H
