// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @file
/// @author  Marek Kurdej <firstname.surname@utc.fr>
/// @date    March, 2013
/// @version $Id$
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.

#include <Pacpus/kernel/DbiteException.h>
#include <Pacpus/kernel/Log.h>
#include <Pacpus/kernel/PacpusApplication.h>

using namespace pacpus;

DECLARE_STATIC_LOGGER("pacpus.core.PacpusApplication");

PacpusApplication::PacpusApplication(int & argc, char ** argv, int)
    : QApplication(argc, argv)
{
}

PacpusApplication::PacpusApplication(int & argc, char ** argv, bool GUIenabled, int)
    : QApplication(argc, argv, GUIenabled)
{
}

PacpusApplication::PacpusApplication(int & argc, char ** argv, Type type, int)
    : QApplication(argc, argv, type)
{
}

#if defined(Q_WS_X11)
PacpusApplication::PacpusApplication(Display * display, Qt::HANDLE visual, Qt::HANDLE colormap, int)
    : QApplication(display, visual, colormap)
{
}

PacpusApplication::PacpusApplication(Display * display, int & argc, char ** argv, Qt::HANDLE visual , Qt::HANDLE colormap, int)
    : QApplication(display, argc, argv, visual, colormap)
{
}
#endif

#if defined(Q_OS_SYMBIAN)
PacpusApplication::PacpusApplication(QApplication::QS60MainApplicationFactory factory, int & argc, char ** argv, int)
    : QApplication(factory, argc, argv)
{
}
#endif

PacpusApplication::~PacpusApplication()
{
}

bool PacpusApplication::notify(QObject * receiver, QEvent * ev)
{
    try {
        return QApplication::notify(receiver, ev);
    } catch(DbiteException & e) {
        LOG_ERROR("DbiteException thrown:" << e.what());
    } catch(std::exception & e) {
        LOG_ERROR("std::exception thrown:" << e.what());
    }
    return false;
}
