
# - Try to find PointGrey Research (PGR) Ladybug library
#
# Once done this will define
#  LADYBUG_FOUND	 - system has PGR Ladybug camera installed
#  LADYBUG_INCLUDE_DIR   - the Ladybug include directory
#  LADYBUG_LIB_DIR	 - the Ladybug lib directory
#  LADYBUG_LIBRARIES - the ladybug libraries

IF(WIN32)
	SET(LADYBUG_ROOT_DIR "$ENV{LADYBUG_ROOT}")
ELSE(WIN32)
	SET(LADYBUG_ROOT_DIR
		/usr/local                                      # Linux: default dir by CMake
		/usr                                            # Linux
		/opt/local                                      # OS X: default MacPorts location
		)
ENDIF(WIN32)

FIND_PATH(LADYBUG_INCLUDE_DIR
	NAMES "ladybug.h" "ladybuggeom.h" "ladybugGPS.h" "ladybugImageAdjustment.h" "ladybugrenderer.h" "ladybugsensors.h" "ladybugstream.h" "ladybugvideo.h" "pgrcameragui.h"
	PATHS "${LADYBUG_ROOT_DIRS}/include/"
	)

FIND_PATH(LADYBUG_LIB_DIR
	NAMES "ladybug.lib" "LadybugGUI.lib"
	PATHS "${LADYBUG_ROOT_DIRS}/lib/"
	)

if(WIN32)
    find_library(LADYBUG_LIBRARIES
        NAMES "ladybug" "LadybugGUI"
        PATHS "${LADYBUG_ROOT_DIR}/lib"
   )
else(WIN32)
    find_library(LADYBUG_LIBRARIES
        NAMES "ladybug" "LadybugGUI"
        PATHS "${LADYBUG_ROOT_DIR}/lib"
   )
endif(WIN32)

message ("******* LIBS: ${LADYBUG_LIBRARIES} ********")

if(EXISTS "${LADYBUG_INCLUDE_DIR}")	
	set(LADYBUG_FOUND TRUE CACHE BOOL "" FORCE)
else()
	set(LADYBUG_FOUND FALSE CACHE BOOL "" FORCE)
endif()
	
# display help message
#IF(NOT BumbleBeeXB3_FOUND)
#    # make FIND_PACKAGE friendly
#    IF(BumbleBeeXB3_FIND_REQUIRED)
#        MESSAGE(FATAL_ERROR "BumbleBeeXB3 not found. Please specify the location of the PGR and Triclops files with the BumbleBeeXB3_ROOT_DIR env. variable.")
#    ELSE(OpenCV2_FIND_REQUIRED)
#        MESSAGE(STATUS "BumbleBeeXB3 not found.")
#    ENDIF(BumbleBeeXB3_FIND_REQUIRED)
#ENDIF(NOT BumbleBeeXB3_FOUND)
