/*********************************************************************
//  created:    2007/07/28 - 11:51
//  filename:   DbtPlyGgaManager.h
//
//  author:     Gerald Dherbomez 
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Dbite Player GGA Manager
*********************************************************************/

#ifndef DBTPLYGGAMANAGER_H
#define DBTPLYGGAMANAGER_H

#include <qlcdnumber.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>

#include "Pacpus/DbitePlayer/DbtPlyFileManager.h"
#include <Pacpus/structure/structure_gps.h>
#include "Pacpus/kernel/ComponentManager.h"//moved from .cpp
//#include "DbitePlayer/SensorTcpServer.h" //added

#include "Pacpus/PacpusTools/ShMem.h"

#include "DbtPlyGpsConfig.h"

namespace pacpus {

class DBTPLYGPS_API DbtPlyGgaManager
        : public DbtPlyFileManager
{
    Q_OBJECT
    
public:
    DbtPlyGgaManager(QString name);
    ~DbtPlyGgaManager();
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

Q_SIGNALS:
    void displayLat(double);
    void displayLon(double);

protected:
    void processData(road_time_t t, road_timerange_t tr , void *buf);
    virtual void startActivity();
    virtual void stopActivity();
    void displayUI();

private:
    trame_gga_dbl* val; 
    QWidget *w;
    QLabel* lat;
    QLCDNumber *latVal;
    QLabel* lon;
    QLCDNumber *lonVal;
    QGroupBox *prop;

};

} // namespace pacpus

#endif // DBTPLYGGAMANAGER_H
