// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @file
/// @author  Marek Kurdej <firstname.surname@utc.fr>
/// @date    Month, 2012
/// @version $Id: DbiteException.h 86 2013-03-27 13:17:43Z morasjul $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Detailed description.

#ifndef DEF_PACPUS_DBITEEXCEPTION_H
#define DEF_PACPUS_DBITEEXCEPTION_H

#include <Pacpus/kernel/FileLibConfig.h>

#include <exception>
#include <string>

namespace pacpus {

/** DbiteException
 * @brief Exception thrown when an error manipulation a dbite file occured.
 */
class FILELIB_API DbiteException
    : public std::exception
{
public:
    /** Ctor of DbiteException.
     * @param what Information about the exception.
     */
    DbiteException(const std::string& what)
        : mWhat(what)
    {
    }

    /** Dtor of DbiteException. */
    virtual ~DbiteException() throw()
    {
    }

    /** Get more information about the error.
     * @return Message containing information about the error.
     */
    virtual const char* what() const throw()
    {
        return mWhat.c_str();
    }

private:
    std::string mWhat;
};

} // namespace pacpus

#endif // DEF_PACPUS_DBITEEXCEPTION_H
