/*********************************************************************
//  created:    2015/04/29
//  filename:   SoftingCanDriver.h
//
//  author:     Pierre Hudelaine
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    driver interface to use softing hardware
*********************************************************************/


#ifndef SOFTINGCANDRIVER_H
#define SOFTINGCANDRIVER_H

#include <string>
#include <windows.h>

#include "CanDriverBase.h"
#include "CanL2.h"
#include "../CanGatewayConfig.h"

// Parameters using in automotive
#define TSEG1 				11
#define TSEG2 				4
#define PRESCALER_500 		1
#define PRESCALER_125 		4
#define SJW 				1
#define SAMPLES 			1
#define ACCEPTANCE_CODE_STD 0x0000
#define ACCEPTANCE_MASK_STD 0x0000
#define ACCEPTANCE_CODE_XTD 0x00000000
#define ACCEPTANCE_MASK_XTD 0x00000000
#define OUTPUT_CONTROL 		0xFA
#define ACKNOLEDGMENT 		1
#define ERRORFRAME 			0
 

class CANGATEWAY_API SoftingCanDriver
    : public CanDriverBase
{
public:
  SoftingCanDriver(void);
  ~SoftingCanDriver(void);


  short initPort (void);
  short cleanUpPort (void);
  short sendFrame (struct CanFrame frame);
  short receiveFrame (struct CanFrame &frame);
  void waitReceivingFrame(void);
  
  void displayHardware(void);

protected:
	
private:


};

#endif // SOFTINGCANDRIVER_H