/*********************************************************************
//  created:    2006/08/08 - 10:36
//  filename:   CanDriver.h
//
//  author:     Gerald Dherbomez
// 
//  version:    $Id: CanDriver.h 1191 2012-07-08 10:26:53Z gdherbom $
//
//  purpose:    This is a generic class which may be used to control 
//              a CAN interface
// 
//              Only one driver can be used in the same application !
// 
*********************************************************************/


#ifndef _CANDRIVER_H_
#define _CANDRIVER_H_


#define VECTOR_CAN_DRIVER	1
#define NI_CAN_DRIVER		2
#define VECTOR_CANXL_DRIVER	3
#define PEAK_CAN_DRIVER 	4
#define IGEP_CAN_DRIVER 	5	
#define PEAK_CAN_DRIVER_WIN	6
#define SOFTING_CAN_DRIVER	7


#if CAN_DRIVER_TYPE == VECTOR_CAN_DRIVER
#include "VectorCanDriver.h"
#define CanDriverType VectorCanDriver
#elif CAN_DRIVER_TYPE == NI_CAN_DRIVER
#include "NiCanDriver.h"
#define CanDriverType NiCanDriver
#elif CAN_DRIVER_TYPE == VECTOR_CANXL_DRIVER
#include "XLVectorCanDriver.h"
#define CanDriverType XLVectorCanDriver
#elif CAN_DRIVER_TYPE == PEAK_CAN_DRIVER
#include "PeakCanDriver.h"
#define CanDriverType PeakCanDriver
#elif CAN_DRIVER_TYPE == IGEP_CAN_DRIVER
#include "igepCanDriver.h"
#define CanDriverType igepCanDriver
#elif CAN_DRIVER_TYPE == PEAK_CAN_DRIVER_WIN
#include "PeakCanDriverWin.h"
#define CanDriverType PeakCanDriverWin
#elif CAN_DRIVER_TYPE == SOFTING_CAN_DRIVER
#include "SoftingCanDriver.h"
#define CanDriverType SoftingCanDriver
#else
#define CanDriverType CanDriverUnknown
#endif 



class CanDriver : public CanDriverType
{
public:
  CanDriver(){};
  CanDriver(int channel) : CanDriverType(channel){}; 
  CanDriver(const int channel, const unsigned int speed)
    : CanDriverType(channel, speed){}; 
  CanDriver(char* port, char* mode):CanDriverType(port, mode){};
  ~CanDriver(){};
protected:
  
private:
};



#endif
