#ifndef ConnectionBase_H
#define ConnectionBase_H


namespace pacpus {

class InputInterfaceBase;

class ConnectionBase
{
public:
    ConnectionBase(InputInterfaceBase * input, int priority):_input(input),_priority(priority) {}
    ~ConnectionBase() {}

    InputInterfaceBase *  getInputInterface() const {return _input;}
    int getPriority() const {return _priority;}

    bool operator== (ConnectionBase const &c) {
        return _input == c.getInputInterface() && _priority == c.getPriority();}

private:
    InputInterfaceBase * _input;
    int _priority;
};

} // namespace pacpus

#endif // ConnectionBase_H
