#ifndef IN_OUT_BASE_H
#define IN_OUT_BASE_H

#include <Pacpus/kernel/ConnectionBase.h>

#include <typeinfo>
#include <QEvent>
#include <QList>
#include <QStringList>

namespace pacpus {

class ComponentBase;

class AbstractInterface : public QObject
{
     Q_OBJECT
protected:
    AbstractInterface(QString name, ComponentBase * component, QObject * parent = 0):_name(name),_component(component),QObject(parent) {}
    ~AbstractInterface(){}
public:
    QString getSignature();
    QString getName() {return _name;}
    virtual QString getDataType() = 0;
    //ComponentBase * getComponent() {return _component;}

protected:
    QString _name;
    ComponentBase * _component;
};

class InputInterfaceBase : public AbstractInterface
{
    Q_OBJECT
public:
    InputInterfaceBase(QString name, ComponentBase * component, QObject * parent = 0):AbstractInterface(name,component,parent) {}
    virtual ~InputInterfaceBase(){}

    virtual void customEvent(QEvent* e) = 0;

};

class OutputInterfaceBase: public AbstractInterface
{
    Q_OBJECT
public:
    OutputInterfaceBase(QString name, ComponentBase * component, QObject * parent = 0):AbstractInterface(name,component,parent) {}
    virtual ~OutputInterfaceBase(){}

    void addConnection(ConnectionBase connection) { _connection.append(connection);}
    bool removeConnection(ConnectionBase connection) { return _connection.removeOne(connection);}

    QStringList getInputConnectedList() {
        QStringList list;
        for(QList<ConnectionBase>::iterator it = _connection.begin(); it!=_connection.end(); ++it)
            list.append(it->getInputInterface()->getName());
        return list;
    }

protected:
    QList<ConnectionBase> _connection;

};

} // namespace pacpus

#endif // IN_OUT_BASE_H
