/*********************************************************************
//  created:    2012/02/22 - 12:00
//  filename:   structureCanSMSRadar.h
//
//  author:     Arthur Miranda (PAMU Project) / Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Description of the CAN structures of SMS Radar
*********************************************************************/

#ifndef __STRUCTURECANSMSRADAR_H__
#define __STRUCTURECANSMSRADAR_H__

#include "kernel/road_time.h"

#define SMS_MAX_OBSTACLE_COUNT 64

// Corresponding CAN frames
/* Front: 0x510 to 0x54F */
/* Left:  0x590 to 0x5CF */
/* Rear:  0x610 to 0x64F */
/* Right: 0x690 to 0x6CF */

// Each individual Central Processor system prioritizes the detected objects and limits the
// number of transmitted objects. To a max of 64 objects.

typedef struct{
	road_time_t time;
	road_timerange_t timerange;
	short moveflag;
	short leadflag;
	short typeflag;
}StructSMSRadarType;

typedef struct{
	road_time_t time;
	road_timerange_t timerange;
	float corXrange;
	float corYrange;
	float corXvel;
	float corYvel;
	int objetID;
	float objetVITESS;
	StructSMSRadarType obtype;
}SMSRadarObj;

typedef struct{

	int numberOfObstacles;
	SMSRadarObj obstacles[SMS_MAX_OBSTACLE_COUNT];

}SMSRadarDatas;

#endif