#ifndef STRUCTURE_IGN_H
#define STRUCTURE_IGN_H

#include "kernel/cstdint.h"
#include "kernel/road_time.h"

#pragma pack(push,4)

/// Applanix IGN data format
struct ApplanixPoint
{
    /// Scanner type id. Alasca has type 2
    uint8_t scannertype;
    uint8_t _padding[3];

    /// DBT timestamp
    road_time_t time;

    /// DBT timerange
    road_timerange_t timerange;

    /// GPS timestamp
    double timeGPS;

    /// distance done up to the moment
    /// \french
    /// distance parcourue
    double distance;

    /// latitude
    double lat;

    /// longitude
    double lon;

    /// ellipsoidal height
    /// \french
    /// hauteur d'ellipsoid
    double hElipsoid;

    /// roll angle
    /// \french
    /// rouli
    double rouli;

    /// pitch angle
    /// \french
    /// tangage
    double tangage;

    /// yaw (heading) angle
    /// \french
    /// cap
    double cap;

    /// speed in X-axis in ENU coordinates
    /// \french
    /// vitesse suivant x en repère ENU
    double vitesseXENU;

    /// speed in Y-axis in ENU coordinates
    /// \french
    /// vitesse suivant y en repère ENU
    double vitesseYENU;

    /// speed in Z-axis in ENU coordinates
    /// \french
    /// vitesse suivant z en repère ENU
    double vitesseZENU;

    /// standard deviation of speed in X-axis in ENU coordinates
    /// \french
    /// ecart-type de la vitesse suivant x en repère ENU
    double SDVitesseXENU;

    /// standard deviation of speed in Y-axis in ENU coordinates
    /// \french
    /// ecart-type de la vitesse suivant y en repère ENU
    double SDVitesseYENU;

    /// standard deviation of speed in Z-axis in ENU coordinates
    /// \french
    /// ecart-type de la vitesse suivant z en repère ENU
    double SDVitesseZENU;

    /// standard deviation of roll angle
    /// \french
    /// ecart-type du rouli
    double SDrouli;

    /// standard deviation of pitch angle
    /// \french
    /// ecart-type du tangage
    double SDtangage;

    /// standard deviation of yaw (heading) angle
    /// \french
    /// ecart-type du cap
    double SDcap;
};

#pragma pack(pop)

/// 2-dimensional pose (position and heading) in geographical coordinates (latitude longitude)
struct Pose2Dlatlong
{
    /// DBT timestamp
    road_time_t time;

    /// latitude
    double lat;

    /// longitude
    double lon;

    /// yaw (heading) angle
    /// \french
    /// cap
    double cap;

    /// standard deviation of yaw (heading) angle
    /// \french
    /// ecart-type du cap
    double SDcap;
};

/// 2-dimensional pose (position and heading) in ENU coordinates (East North Up)
struct Pose2Denu
{
    /// DBT timestamp
    road_time_t time;

    /// latitude
    double x;

    /// longitude
    double y;

    /// yaw (heading) angle
    /// \french
    /// cap
    double cap;

    /// standard deviation of yaw (heading) angle
    /// \french
    /// ecart-type du cap
    double SDcap;
};

#endif // STRUCTURE_IGN_H
