/*********************************************************************
//  created:    2007/11/13 - 10:49
//  filename:   AlascaSocket.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Defintion of the AlascaSocket class
//              Management of the socket connection with the Alasca
*********************************************************************/

#ifndef _ALASCASOCKET_H_
#define _ALASCASOCKET_H_

#include <cmath>
#include <QObject>
#include <QTcpSocket>
#include <QMutex>
#include <QEvent>

#include "kernel/road_time.h"

namespace pacpus {

class AlascaFrame
{
public:
    AlascaFrame()
    {
        size = 0;
        time = 0;
        msg = NULL;
    }
    
    ~AlascaFrame()
    {
        delete[] msg; // check for NULL is not necessary
    }
    
    int size; 
    road_time_t time; 
    char * msg; 
};

// forward declaration
class AlascaComponent;

class AlascaFrameEvent
        : public QEvent
{
public:
    AlascaFrameEvent()
            : QEvent((QEvent::Type)(QEvent::User + 522))
    {}
    
    ~AlascaFrameEvent()
    {}
    
    AlascaFrame * frame;
};

class AlascaSocket
        : public QObject
{
  Q_OBJECT 
 
public:
    AlascaSocket(QObject * parent);
    ~AlascaSocket();

public Q_SLOTS:
    // enable the connection to the server
    void connectToServer(QString host, int port);

    //avertit que le socket est connect
    int socketConnected();

    // appel lorsque de nouvelles donnes sont arrives sur le socket
    void socketReadyRead();  

    // close the connection with the server 
    void closeSocket() { socket->close(); }

Q_SIGNALS:
    // signal emis pour demander la configuration du tlmtre 
    void configuration(); 

protected slots:
    // fonction d'envoi des donnes au tlmtre
    void sendToServer(QString data); 


    // le socket est ferm par le serveur
    void socketConnectionClosed();

    // une erreur est survenue
    void socketError(QAbstractSocket::SocketError e); 

private:
    QTcpSocket *socket; 
    QMutex mutex;

    AlascaComponent * myParent; 
};

} // namespace pacpus

#endif