/*************************************************************************** 
*
* Copyright 2000 by David Demirdjian.   All rights reserved. 
*  
* Developed  by David Demirdjian
*  
* Permission to use, copy, or modify this software and  its documentation 
* for  educational  and  research purposes only and without fee  is hereby 
* granted, provided  that this copyright notice and the original authors's 
* names appear  on all copies and supporting documentation.  If individual 
* files are  separated from  this  distribution directory  structure, this 
* copyright notice must be included.  For any other uses of this software, 
* in original or  modified form, including but not limited to distribution 
* in whole or in  part, specific  prior permission  must be  obtained from 
* MIT.  These programs shall not  be  used, rewritten, or  adapted as  the 
* basis  of  a  commercial  software  or  hardware product  without  first 
* obtaining appropriate  licenses from David Demirdjian.  The author makes 
* no representations about the suitability of this software for any purpose.  
* It is provided "as is" without express or implied warranty. 
*  
**************************************************************************/
#ifndef _DATASTRUCTURES_H
#define _DATASTRUCTURES_H

// ********************************************************************
// ********************************************************************
// InputImages: structure containing the input images (at a given scale)
class InputImages {
public:
	InputImages();
	~InputImages();
	void alloc(int w, int h, int extra_margin);
	void deAlloc();

	int numImages; // 2 (pair) or 3
	unsigned char *subIm_l,  *subIm_r,  *subIm_t; 
	unsigned char *subIm_l_origin,  *subIm_r_origin,  *subIm_t_origin; 
};

// **********************************************************************
// StereoImage: structure representing the depth information (disparity and sub-pixel) 
//				at a given scale. 
//				This contains in particular: imDepth8u and imDepth32f
//				which contain the disparity images (size width*height, 8bits unsigned char 
//				and 32bits float) stored as 1-dim. arrays.
class StereoImage {
public:
	StereoImage();
	~StereoImage();
	void alloc(int w, int h);
	void deAlloc();
	void Reset(void);

	void createValidPixelsList(int topmargin);
	// create some 'borders' around the stereo image
	void setUndefinedBorders(int leftMargin, int rightMargin);
	// set the undefined depth value ... 
	void setUndefinedDepthValue(const unsigned char undefined_val);

	void generateDepth32f();
	void generateDepth8uFromDepth32f();

	// ***** dense representation *************
	int width,height;
	// disparity image (8bits unsigned char)
	unsigned char *imDepth8u, *imDepth8u_origin; 	
	// disparity image (32bits float)
	float *imDepth32f, *imDepth32f_origin; 	

	// ***** sparse representation *************
	// index of valid pixels in imDepth
	int *valid_pixels;	
	short *x, *y;
	float *depth_float_list;
	unsigned int m_nGood3DPoints;		// nb of valid pixels

	// undefined depth value: all undefined pixels in the disp. image  will have this value
	unsigned char UNDEFINED_DEPTH;

private:
	int *valid_pixels_origin;
	short *x_origin, *y_origin;
	float *depth_float_list_origin;
};


// ***********************************************************************
// ***********************************************************************
// ReconstPoints3D: structure representing a 3D Euclidean reconstruction
class ReconstPoints3D {
public:
	ReconstPoints3D();
	~ReconstPoints3D();
	void alloc(int N);
	void FreeMemoryBuffers(void);

	// I/O functions to load/save a 3D reconstruction
	int load(char* filename);
	int save(char* filename);

	// return arrays containing 3-D reconstruction
	float* getXlist() const;
	float* getYlist() const;
	float* getZlist() const;
	unsigned char* getARGBlist() const;	// color (ARGB) list
	float* getPointSizelist() const;	// size of the points

	// return num. of reconstructed points
	int getNumPoints() const;

	// return 3 images containing X,Y and Z values
	void getImages_3D(float* X_im, float* Y_im, float* Z_im, const int* valid_pixels);

	friend class Reconst3D;

	// ROI of thte scene
	float m_fExtentMinX;
	float m_fExtentMaxX;
	float m_fExtentMinY;
	float m_fExtentMaxY;
	float m_fExtentMinZ;
	float m_fExtentMaxZ;

protected:
	// 3D reconstruction
	float *m_p3DPointsX;
	float *m_p3DPointsY;
	float *m_p3DPointsZ;
	unsigned char *m_p3DPointsC;	// list of RGBA values
	float *m_p3DPointsS;			// size of the 3D points
	unsigned int m_nGood3DPoints;	// number of points in the scene

private:
	// original data pointers
	float *m_p3DPointsX_origin;
	float *m_p3DPointsY_origin;
	float *m_p3DPointsZ_origin;
};

#endif