/*************************************************************************** 
*
* Copyright 2000 by David Demirdjian.   All rights reserved. 
*  
* Developed  by David Demirdjian
*  
* Permission to use, copy, or modify this software and  its documentation 
* for  educational  and  research purposes only and without fee  is hereby 
* granted, provided  that this copyright notice and the original authors's 
* names appear  on all copies and supporting documentation.  If individual 
* files are  separated from  this  distribution directory  structure, this 
* copyright notice must be included.  For any other uses of this software, 
* in original or  modified form, including but not limited to distribution 
* in whole or in  part, specific  prior permission  must be  obtained from 
* MIT.  These programs shall not  be  used, rewritten, or  adapted as  the 
* basis  of  a  commercial  software  or  hardware product  without  first 
* obtaining appropriate  licenses from David Demirdjian.  The author makes 
* no representations about the suitability of this software for any purpose.  
* It is provided "as is" without express or implied warranty. 
*  
**************************************************************************/
#ifndef _PROCESSING_MMX_H
#define _PROCESSING_MMX_H

typedef unsigned char uchar;
typedef unsigned short ushort;

// translate image of 'tx' pixels to the right
// (or left if tx<0)
inline void translateImage(int tx, uchar* data1, int siz);

// normalize intensities in images
inline void normalizeImages(uchar* data1, uchar* data2, uchar* data3, int siz);
inline void normalizeImages(uchar* data1, uchar* data, int siz);
inline void normalizeImages(const uchar* data1, const uchar* data2, const uchar* data3, 
							uchar* out1, uchar* out2, uchar* out3, int siz);
inline void normalizeImages(const uchar* data1, const uchar* data2, 
							uchar* out1, uchar* out2, int siz);

// shrink images by a factor 'fact'. eg if fact = 2, out will be twice as small as src
inline void shrinkImages(uchar* dst, const uchar* src, int width, int height, int fact);


//  ImgSub2: D = saturation0(|S1 - S2| + |S1 - S3|)
inline int ImgSubandAdd(const uchar *Src1, const uchar *Src2, 
				 const uchar *Src3, uchar *Dest, int l);
// int ImgSubandAdd_sse2(const uchar *Src1, const uchar *Src2, const uchar *Src3, uchar *Dest, int l);
inline int ImgSubandAdd(const uchar *Src1, const uchar *Src2, 
				 uchar *Dest, int l);

inline int ImgSubandAdd2(const uchar *Src1, const uchar *Src2, 
					 const uchar *Src3, uchar* Dest1, int l, int imageSize, int width);
inline int ImgSubandAdd2_Vert(const uchar *Src1, const uchar *Src2, 
						 uchar* Dest1,
						 int l, int imageSize, int width);
inline int ImgSubandAdd_Horiz(const uchar *Src1, const uchar *Src3, uchar* Dest1,
						 int l, int imageSize, int width);



// ---------------------
// init BestCorrelation and SecondCOrrelation with CurrentCorrelation
// init Disparity with disparityInit
inline int initMinimumCorrelation(const uchar *CurrentCorrelation, uchar disparityInit,	uchar *Disparity,	
						   uchar *BestCorrelation, 	uchar *SecondCorrelation,	int bytecount);
// ----------------------
// FULL IMAGE, BEST ONLY : Keith's code
inline int findMinimumCorrelation_mmx(const uchar *CurrentCorrelation,	uchar CurrentDisparity,	uchar *Disparity,
							uchar *BestCorrelation, int bytecount) ;
// ----------------------
// FULL IMAGE, BEST+SECOND : Keith's code
inline int findMinimumCorrelation_mmx(	const uchar *CurrentCorrelation,	uchar CurrentDisparity,	uchar *Disparity,
								uchar *BestCorrelation,	uchar *SecondCorrelation,	int bytecount);



// ------------------------ image filters -------------------------------
inline void sum_5x5_mmx(uchar* im, ushort* im_out, int dataSize, int width, ushort* buff);
inline void sum_5x5_mmx(uchar* im, uchar* im_out, int dataSize, int width, ushort* buff);

// ------- row filters -------
 template<class T> void sum_Row_5(T* im, ushort* im_out, int rowSize);
 inline void sum_Row_mmx(uchar* im, ushort* im_out, int rowSize, int maskSize);
 inline void sum_Row_mmx(ushort* im, ushort* im_out, int rowSize, int maskSize) ;
 inline void sum_Row_5_mmx(uchar* im, ushort* im_out, int rowSize);
 inline void sum_Row_5_mmx(ushort* im, ushort* im_out, int rowSize);

// ------- cols filters -------
 inline void avg_Col(ushort* im, uchar* im_out, int dataSize, int width, int sizeMask);

 inline void avg_Col_mmx(ushort* im, uchar* im_out, int dataSize, int width, int sizeMask);
 inline void avg_Col_sse2(ushort* im, uchar* im_out, int dataSize, int width, int sizeMask);
 inline void avg_Col_5(ushort* im, uchar* im_out, int dataSize, int width);
 inline void avg_Col_7(ushort* im, uchar* im_out, int dataSize, int width);
 inline void avg_Col_9(ushort* im, uchar* im_out, int dataSize, int width);
 inline void avg_Col_11(ushort* im, uchar* im_out, int dataSize, int width);
 inline void avg_Col_13(ushort* im, uchar* im_out, int dataSize, int width);
 inline void avg_Col_15(ushort* im, uchar* im_out, int dataSize, int width);
 inline void avg_Col_17(ushort* im, uchar* im_out, int dataSize, int width);

inline void add_Col_5_wb(ushort* im, uchar* im_out, int dataSize, int width);
inline void add_Col_5_ww(ushort* im, ushort* im_out, int dataSize, int width);

// ------- cols filters -------
inline void avg_Col_5_sse2(ushort* im, uchar* im_out, int dataSize, int width);
inline void avg_Col_7_sse2(ushort* im, uchar* im_out, int dataSize, int width);
inline void avg_Col_9_sse2(ushort* im, uchar* im_out, int dataSize, int width);
inline void avg_Col_11_sse2(ushort* im, uchar* im_out, int dataSize, int width);
inline void avg_Col_13_sse2(ushort* im, uchar* im_out, int dataSize, int width);


// return the average pixel value
inline float pixelMean(const uchar* im, int imageSize);

// check that the diff. between best and second disp. scores in great enough
inline void compareBestAndSecond(uchar* bestScores, uchar* secondScores, char thresh, 
						 uchar valForReplacement, 
						 uchar* disp, int dataSize);

// image copy 
// windowWidth must be multiple of 8
inline void cropImage(const uchar* imSrc, int width, int height, 
			   uchar* imDest, int x0, int y0, int windowWidth, int windowHeight);



// apply mask:	 if mask[]==undefined_val	im[]->im[]
//				 otherwise					im[]->mask[]
inline void overrideImage(uchar* im, const uchar* mask, uchar undefined_val, int imageSize);
inline void overrideImageMMX(uchar* im, const uchar* mask, uchar undefined_val, int imageSize);
inline void copyMMX(void* imDest, const void* imSrc, int dataSize);
inline void copySSE(void* imDest, const void* imSrc, int dataSize);
inline void setMMX(float* imDest, const float value, int dataSize);
inline void setMMX(char* imDest, const char value, int dataSize);

// multiply im. by a constant 'fact'
inline void multiply(uchar* im, float fact, int imageSize);
inline void multiply(const uchar* imSrc, uchar* imDest, float fact, int imageSize);
inline void divide(ushort* im,  uchar* div, uchar* result, int imageSize);
inline void binarize(uchar* im, uchar* im_out, uchar undefined_val, int dataSize);
inline void set_undefined_to_zero(uchar* im, uchar* im_out, uchar undefined_val, int dataSize);
inline void set_zero_to_undefined(uchar* im, uchar* im_out, uchar undefined_val, int dataSize);

// check depth validity
void checkDisparityValidity(uchar* disp, uchar* buff, int buffStep, 
							uchar* bestScore, uchar tol, 
							uchar undefined_val, uchar nbDepth, 
							int imageSize);
void checkDisparityValidityAndSearchAround(uchar* disp, uchar* buff, int buffStep, 
											uchar* bestScore, uchar tol, 
											uchar undefined_val, uchar nbDepth, 
											int imageSize);
// 3D reconst
//void createIdxValidPixelsList(const uchar* depth_image, int* idx_valid_pixels, int& nbPoints, int siz, int UNDEFINED_DEPTH);

#include "processingMMX.inl"
#include "processingSSE2.inl"

#endif
