/*************************************************************************** 
*
* Copyright 2000 by David Demirdjian.   All rights reserved. 
*  
* Developed  by David Demirdjian
*  
* Permission to use, copy, or modify this software and  its documentation 
* for  educational  and  research purposes only and without fee  is hereby 
* granted, provided  that this copyright notice and the original authors's 
* names appear  on all copies and supporting documentation.  If individual 
* files are  separated from  this  distribution directory  structure, this 
* copyright notice must be included.  For any other uses of this software, 
* in original or  modified form, including but not limited to distribution 
* in whole or in  part, specific  prior permission  must be  obtained from 
* MIT.  These programs shall not  be  used, rewritten, or  adapted as  the 
* basis  of  a  commercial  software  or  hardware product  without  first 
* obtaining appropriate  licenses from David Demirdjian.  The author makes 
* no representations about the suitability of this software for any purpose.  
* It is provided "as is" without express or implied warranty. 
*  
**************************************************************************/
#ifndef _RECONST3D_H
#define _RECONST3D_H

class StereoImage;
class ReconstPoints3D;
#ifdef _USEGDI
#include <gdiplus.h>
#else
class Bitmap;
#endif

// ********************************************************************
// ********************************************************************
// Reconst3D: class used for 3D Euclidean reconstruction stereo images
class Reconst3D
{
public:
	Reconst3D();
	~Reconst3D();

	enum Error { CAMERA_PARAM_NOT_SET, IMAGE_BUFFER_NULL, WRONG_IMAGE_SIZE, RECONST_OK };

	// -------- set/get stereo parameters -------- 
	void setCameraParameters(float focal, float baseline, float u0, float v0);
	void getCameraParameters(float& focal, float& baseline, float& u0, float& v0) const;

	// -----------------------------------------------------------------------
	// -------- doReconstruction: 3D reconstruction of the full scene -------- 
	// input: 
	// - pStereoData: Pointer on a StereoImage structure containing the stereo data
	// output:
	// - reconstPts3d: Pointer on a the calculated 3D reconstruction
	int doReconstruction(ReconstPoints3D* reconstPts3d, const StereoImage* pStereoData);

//#ifdef _USEGDI
	// ------------------------------------------------------------------------------
	// -------- doReconstruction: 3D reconstruction of the full scene with color info 
	// input: 
	// - pStereoData: Pointer on a StereoImage structure containing the stereo data
	// output:
	// - reconstPts3d: Pointer on a the calculated 3D reconstruction
	int doReconstruction(ReconstPoints3D* reconstPts3d, const StereoImage* pStereoData,
						 Bitmap *bitmap);
//#endif
	// camera parameters
	float m_fFocalLength;
	float m_fBaseLine;
	float m_u0;
	float m_v0;
};

#endif