/*************************************************************************** 
*
* Copyright 2000 by David Demirdjian.   All rights reserved. 
*  
* Developed  by David Demirdjian
*  
* Permission to use, copy, or modify this software and  its documentation 
* for  educational  and  research purposes only and without fee  is hereby 
* granted, provided  that this copyright notice and the original authors's 
* names appear  on all copies and supporting documentation.  If individual 
* files are  separated from  this  distribution directory  structure, this 
* copyright notice must be included.  For any other uses of this software, 
* in original or  modified form, including but not limited to distribution 
* in whole or in  part, specific  prior permission  must be  obtained from 
* MIT.  These programs shall not  be  used, rewritten, or  adapted as  the 
* basis  of  a  commercial  software  or  hardware product  without  first 
* obtaining appropriate  licenses from David Demirdjian.  The author makes 
* no representations about the suitability of this software for any purpose.  
* It is provided "as is" without express or implied warranty. 
*  
**************************************************************************/
#ifndef _STEREOBUFFER_H
#define _STEREOBUFFER_H


// ********************************************************************
// ********************************************************************
// StereoBuffer: class containing all the buffers necessary for stereo 
// computation (at a fixed scale)
class StereoBuffer {
public:
	StereoBuffer();
	~StereoBuffer();
	
	void setSize(int width, int height, int maxNbDepth);
	void alloc();
	void deAlloc();
	void allocTempBuffer16();
	void deAllocTempBuffer16();

	inline void filterSAD(int maskX, int maskY, 
						  unsigned char* ptBuff, unsigned short* ptBuff16,
						  int backStep, int subImageSize, int offset);

	int width, height, maxNbDepth;

	// minimum disparity scores
	unsigned char* getCorrScores() const;
	// second minimum disparity scores
	unsigned char* getCorrScores_Sec() const;

	// buffers used for 8-bits use
	int buffStep;
	unsigned char** buff;
	unsigned char* bigBuffer, *bigBuffer_origin;
	unsigned short **buff16;
	unsigned short *bigBuffer16, *bigBuffer16_origin; // buffers used for 16-bits use

	// corr. scores associated with depth
	unsigned char* corrScore, *corrScoreSec;
	unsigned char* corrScore_origin, *corrScoreSec_origin; // corr. scores associated with depth

	// stereo grow 
	unsigned char *imDepth_ref, *imDepth_ref_origin; 
	unsigned short *Depth16, *Depth16_origin; 
	unsigned short *buffTemp, *buffTemp_origin;	// intermediate buffer used for 'sum_row' filtering  (16-bits)
	unsigned char* count_non_null_pixels, *count_non_null_pixels_origin;

};

#include "stereobuffer.inl"

#endif