#include "ShMemInterface.h"

#include "kernel/ComponentFactory.h"
#include "kernel/Log.h"
#include "PacpusTools/ShMem.h"
#include "Pacpus/kernel/inputOutputInterface.h"
#include <Pacpus/kernel/PacpusEvent.h>


using namespace std;
using namespace pacpus;

DECLARE_STATIC_LOGGER("pacpus.base.ShMemOutput");

// Construct the factory
static ComponentFactory<ShMemOutput> sFactory("ShMemOutput");

void ShMemOutput::addInputOutput()
{
    ADD_OUTPUT("data",ShMemOutput,QByteArray);
}

//////////////////////////////////////////////////////////////////////////
/// Constructor.
ShMemOutput::ShMemOutput(QString name)
    : ComponentBase(name)
{   
    LOG_TRACE("constructor(" << name << ")");
    shMemSize_ = sizeof(size_t);
    shMemName_ = name; // default name
    timeout_ = 10;
    addInputOutput();
}

//////////////////////////////////////////////////////////////////////////
/// Destructor.
ShMemOutput::~ShMemOutput()
{
    LOG_TRACE("destructor");

}

//////////////////////////////////////////////////////////////////////////
/// Called by the ComponentManager to start the component
void ShMemOutput::startActivity()
{
    shmemSize_ = new ShMem(shMemSizeName_.toStdString().c_str(), sizeof(size_t));
    shmem_ = NULL;

    start();
    THREAD_ALIVE = true;
    setState(MONITOR_OK);
    LOG_INFO("started component '" << componentName << "'");
}

//////////////////////////////////////////////////////////////////////////
/// Called by the ComponentManager to stop the component
void ShMemOutput::stopActivity()
{
    THREAD_ALIVE = false;

    setState(STOPPED);
    LOG_INFO("stopped component '" << componentName << "'");
}

//////////////////////////////////////////////////////////////////////////
/// Called by the ComponentManager to pass the XML parameters to the
/// component
ComponentBase::COMPONENT_CONFIGURATION ShMemOutput::configureComponent(XmlComponentConfig config)
{
    if (param.getProperty("memoryName") != QString::null)
        shMemName_ = param.getProperty("memoryName");

    if (param.getProperty("timeout") != QString::null)
        timeout_ = param.getProperty("timeout").toInt();

    shMemSizeName_ = shMemName_ + "Size";

    return ComponentBase::CONFIGURED_OK;
}

void ShMemOutput::run()
{
    while(THREAD_ALIVE) {

    if(shmemSize_->wait(timeout_)) {
                      qDebug() << "t[13]= " << road_time();

        shmemSize_->lockMemory();
        size_t readedSize = *((size_t*)shmemSize_->read());
        shmemSize_->unlockMemory();

        if(shmem_ == NULL) {
            shMemSize_ = readedSize;
           shmem_ = new ShMem(shMemName_.toStdString().c_str(), shMemSize_);
        }

        if(readedSize != shMemSize_) {
            LOG_WARN("Shared Memory size incorect");
            continue;
        }
              qDebug() << "t[14]= " << road_time();
        //LOG_INFO("Shmem size = " << shMemSize_ << " " << readedSize);
        shmem_->lockMemory();
        char * ptr = (char*)shmem_->read();
        GET_OUTPUT("data",ShMemOutput,QByteArray)->sendGenericData(ptr,shMemSize_);
        shmem_->unlockMemory();

        setState(MONITOR_OK);

    } else  {
        setState(MONITOR_NOK);
        LOG_WARN("Component " << componentName << " timeout !!!")
    }

    }

    delete shmemSize_;
    delete shmem_;

}

