/**
@file
Purpose: Lidar Detection

@date created 2010-06-03 16:13
@author Julien Moras
@author Sergio Rodriguez
@version $Id: $
*/

#ifndef TestComponent2_H
#define TestComponent2_H

#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/inputOutputInterface.h>

#include <Pacpus/kernel/road_time.h>
#include <Pacpus/PacpusTools/pacpusStruct.h>

#include <QThread>
#include <QImage>

namespace pacpus {

class TestComponent2
        : public QObject
        , public ComponentBase
{
    Q_OBJECT

public:
    static const char * COMPONENT_TYPE;

    TestComponent2(QString name);
    ~TestComponent2();

    virtual void stopActivity();
    virtual void startActivity();
    virtual COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
     void process2(const QImage& matrix);

public slots:
     void addInputOutput();
private:
    QMutex mutex;

    QImage matrix;
    QThread thread;

    int i;

    FILE *fp;

};

} // namespace pacpus

#endif // TestComponent2_H
