#ifndef Communication_Component_H
#define Communication_Component_H

#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/Log.h>

namespace pacpus {

class CommunicationInterface : public ComponentBase
{
public:

    CommunicationInterface(QString );
    virtual ~CommunicationInterface() = 0;

    virtual void stopActivity() = 0;
    virtual void startActivity() = 0;
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config) = 0;

    virtual void send(char* data, size_t size) = 0;
    virtual void send(QByteArray) = 0;

    //virtual void setDataSize(size_t size) {_size = size;}
protected:
    size_t _size;
};


} // namespace pacpus

#endif // Communication_Component_H
