#ifndef PACPUS_EVENT_H
#define PACPUS_EVENT_H

#include <QEvent>
#include "Pacpus/kernel/road_time.h"

namespace pacpus {

class GenericData {
public:
    GenericData(char* data, size_t size) {
        _data = (char*)malloc(size);
        memcpy(_data,data,size);
        _size = size;}

    ~GenericData() {free(_data);}

    char * data() { return _data;}
    size_t size() {return _size;}

private:
char* _data;
size_t _size;
};

enum PacpusEventType  {
    TYPED_EVENT = 1000,
    GENERIC_EVENT = 2000,
    GENERIC_EVENT2 = 2002,
    GENERIC_EVENT3 = 2003,
    CONFIG_EVENT = 3000
};

class PacpusEvent : public QEvent
{
public:
    PacpusEvent(QEvent::Type type):QEvent(type) {}
};

template<class T>
class PacpusTypedEvent : public PacpusEvent
{
public:
    PacpusTypedEvent(QEvent::Type type, T data, road_time_t t = road_time(), road_timerange_t tr = 0 ):PacpusEvent(type)
    {_data = data; t_ = t; tr_ = tr;}
    ~PacpusTypedEvent() {}
    T _data;
    road_time_t t_;
    road_timerange_t tr_;
};

class PacpusGenericEvent : public PacpusEvent
{
public:
    PacpusGenericEvent(QEvent::Type type, char* data, size_t size):PacpusEvent(type) {
        _data = (char*)malloc(size);
        memcpy(_data,data,size);
        _size = size;

    }
    virtual ~PacpusGenericEvent() {free(_data);}
    char* _data;
    size_t _size;
};


} // namespace pacpus

#endif // PACPUS_EVENT_H
