/*********************************************************************
//  created:    2011/06/08 - 10:30
//  filename:   structureFaceLAB.h
//
//  author:     Anthony CHAIKHA DOUAIHY
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Description of the FaceLAB structures
*********************************************************************/

#ifndef _STRUCTURE_FACELAB_H_
#define _STRUCTURE_FACELAB_H_

#include "kernel/road_time.h"

typedef struct {
    road_time_t time;
	//Frame Number
	int frameNumber; 
	//Frame time - number of seconds since 1/1/1970
	int gmt_s; 
	//Annotation label
	int annotation_ID;
	//Index of the world object the filteres gaze vector intersects (-1=none)
	int gaze_obj_index; 
	//Gaze direction vector screen intersection X, Y (pixel coordinates)
	int gsi_pixel_x, gsi_pixel_y;
	//Frame time - milliseconds part of GMT_S
	unsigned short gmt_ms;
	//Gaze direction vector screen intersection X, Y, Z
	float gsi_world_x, gsi_world_y, gsi_world_z;
	//Approxy delay in seconds between image generation and logger data release
	float delay;
	//Head position filtered X, Y, Z
	float hpos_filtx, hpos_filty, hpos_filtz;
	//Left eye closure confidence (0=low, 1=high)
	float left_clos_conf;
	//Right eye closure confidence (0=low, 1=high)
	float right_clos_conf;
	//Eye closure calibration (0=no calibration, 1=full calibration)
	float eye_close_calib;
	//Blink frequency
	float blinking_freq;
	//Head rotation Euler angle alpha, beta, gamma
	float hrot_filtx, hrot_filty, hrot_filtz; 
	//Head position confidence (0=low, 100=high)
	float hpos_conf;
	//Right eyeball centre position X, Y, Z
	float h_eyeball_r_x, h_eyeball_r_y, h_eyeball_r_z;
	//Left eyeball centre position X, Y, Z
	float h_eyeball_l_x, h_eyeball_l_y, h_eyeball_l_z;
	//Right eye closure fraction (0=open, 1=closed)
	float right_eye_close;
	//Left eye closure fraction (0=open, 1=closed)
	float left_eye_close;
	//Average blink duration
	float blinking_duration;
	//Perclos value
	float perclos;
	//Gaze direction vector screen intersection X, Y (screen coordinates)
	float gsi_screen_x, gsi_screen_y;
	//Gaze object intersection X, Y, Z (world coordinates)
	float goi_x, goi_y, goi_z;
	//X, Y coord of right eye pupil position in image from camera A
	float r_pupilos_ca_x, r_pupilos_ca_y;
	//(X, Y)  of left eye pupil position in image from camera A
	float l_pupilos_ca_x, l_pupilos_ca_y;
	//(X, Y, width, height) of top left hand corner of face rectangle in the image from camera A
	float facerect_ca_x, facerect_ca_y, facerect_ca_w, facerect_ca_h;
	//(X, Y, width, height) of top left hand corner of right eye rectangle in the image from camera A
	float reyerect_ca_x, reyerect_ca_y, reyerect_ca_w, reyerect_ca_h;
	//(X, Y, width, height) of top left hand corner of left eye rectangle in the image from camera A
	float leyerect_ca_x, leyerect_ca_y, leyerect_ca_w, leyerect_ca_h;
	//(X, Y, width, height) of top left hand corner of mouth rectangle in the image from camera A
	float moutrect_ca_x, moutrect_ca_y, moutrect_ca_w, moutrect_ca_h;
	//X, Y coord of right eye pupil position in image from camera B
	float r_pupilos_cb_x, r_pupilos_cb_y;
	//(X, Y)  of left eye pupil position in image from camera B
	float l_pupilos_cb_x, l_pupilos_cb_y;
	//(X, Y, width, height) of top left hand corner of face rectangle in the image from camera B
	float facerect_cb_x, facerect_cb_y, facerect_cb_w, facerect_cb_h;
	//(X, Y, width, height) of top left hand corner of right eye rectangle in the image from camera B
	float reyerect_cb_x, reyerect_cb_y, reyerect_cb_w, reyerect_cb_h;
	//(X, Y, width, height) of top left hand corner of left eye rectangle in the image from camera B
	float leyerect_cb_x, leyerect_cb_y, leyerect_cb_w, leyerect_cb_h;
	//(X, Y, width, height) of top left hand corner of mouth rectangle in the image from camera B
	float moutrect_cb_x, moutrect_cb_y, moutrect_cb_w, moutrect_cb_h;
	//Right eye gaze quality level
	int gaze_quality_r;
	///Left eye gaze quality level
	int gaze_quality_l;
	//Right eyeball centre position X, Y, Z
	float eyeball_r_x, eyeball_r_y, eyeball_r_z;
	//Right eye gaze pitch and yaw angle
	float gazerot_r_x, gazerot_r_y;
	//Left eyeball centre position X, Y, Z
	float eyeball_l_x, eyeball_l_y, eyeball_l_z;
	//Mean Eyes
	float eyeball_x, eyeball_y, eyeball_z;
	//Left eye gaze pitch and yaw angle
	float gazerot_l_x, gazerot_l_y;
	//Right gaze vector X, Y, Z
	float r_nx, r_ny, r_nz;
	//Left gaze vector X, Y, Z
	float l_nx, l_ny, l_nz;
	//Mean gaze vector X, Y, Z
	float nx, ny, nz;
}FaceLABDatas;

#endif

