#ifndef _STRUCTURE_CUBE_H_
#define _STRUCTURE_CUBE_H_

#include "kernel/road_time.h"

 /*DYNA_ROADYN*/
 
struct StructureRoadynamics{
  road_time_t time,time_cube;                 // DBT timestamp
  road_timerange_t timerange;       // DBT timerange
 /////////////////////front left wheel/////////////// 
  double fx_AVG;         //longitudinal force of the front left wheel (in mv/N)
  double fy_AVG;			//vertical force of the front left wheel (in mv/N)
  double fz_AVG;			//lateral force of the front left wheel (in mv/N)
  double mx_AVG;         //longitudinal moment of the front left wheel (in mv/N)
  double my_AVG;			//vertical moment of the front left wheel (in mv/N.m)
  double mz_AVG;			//lateral moment of the front left wheel (in mv/N.m)
  double angle_AVG;			//front left wheel angle (v/deg)
  double omega_AVG;			//angular velociet of the front left wheel (in vs/deg)
  
/////////////////////rear left wheel/////////////// 
  double fx_ARG;         //longitudinal force of the rear left wheel (in mv/N)
  double fy_ARG;			//vertical force of the rear left wheel (in mv/N)
  double fz_ARG;			//lateral force of the rear left wheel (in mv/N)
  double mx_ARG;			//longitudinal moment of the rear left wheel (in mv/N)
  double my_ARG;			//vertical moment of the rear left wheel (in mv/N)
  double mz_ARG; 		//lateral moment of the rear left wheel (in mv/N)
  double angle_ARG;			//rear left wheel angle (v/deg)
  double omega_ARG;			//angular velociet of the rear left wheel (in vs/deg)
  
   /////////////////////front right wheel/////////////// 
  double fx_AVD;         //longitudinal force of the front right wheel (in mv/N)
  double fy_AVD;			//vertical force of the front right wheel (in mv/N)
  double fz_AVD;			//lateral force of the front right wheel (in mv/N)
  double mx_AVD;			//longitudinal moment of the front right wheel (in mv/N)
  double my_AVD;			//vertical moment of the front right wheel (in mv/N)
  double mz_AVD; 		//lateral moment of the front right wheel (in mv/N)
  double angle_AVD;			//front right wheel angle (v/deg)
  double omega_AVD;			//angular velociet of the front right wheel (in vs/deg)
  
   /////////////////////rear left wheel/////////////// 
  double fx_ARD;         //longitudinal force of the rear right wheel (in mv/N)
  double fy_ARD;			//vertical force of the rear right wheel (in mv/N)
  double fz_ARD;			//lateral force of the rear right wheel (in mv/N)
  double mx_ARD;			//longitudinal moment of the rear right wheel (in mv/N)
  double my_ARD;			//vertical moment of the rear right wheel (in mv/N)
  double mz_ARD; 		//lateral moment of the rear right wheel (in mv/N)
  double angle_ARD;			//rear right wheel angle (v/deg)
  double omega_ARD;			//angular velociet of the rear right wheel (in vs/deg)
  
  
  
};
 
 /*DYNA_HT500*/ 
struct StructureHT500{
  road_time_t time,time_cube;                 // DBT timestamp
  road_timerange_t timerange; 		 // DBT timerange
  double hCaisse_AVG;		//the height of the car body at the front left corner (in cm)
  double hCaisse_AVD;		//the height of the car body at the front right corner (in cm)
  double hCaisse_ARG;		//the height of the car body at the rear left corner (in cm)
  double hCaisse_ARD;		//the height of the car body at the rear right corner (in cm)
 };
 

/*DYNA_CUBE_RAWDATA*/ 
struct StructureCubeRawData{
  road_time_t time,time_cube;                 // DBT timestamp
  road_timerange_t timerange;       // DBT timerange
  double debat_AVG;		//deflection of the front left suspension (in cm)
  double debat_AVD;		//deflection of the front right suspension (in cm)
  double debat_ARG;		//deflection of the rear left suspension (in cm)
  double debat_ARD;		//deflection of the rear right suspension (in cm)
  
  double hCaisse_AVG;		//the height of the car body at the front left corner (in cm)
  double hCaisse_AVD;		//the height of the car body at the front right corner (in cm)
  double hCaisse_ARG;		//the height of the car body at the rear left corner (in cm)
  double hCaisse_ARD;		//the height of the car body at the rear right corner (in cm)
  
  double derivear;			//sideslip angle at the back of the car (in degree)
  double normal_vitesse;    //normal speed (in km/h)
  double vitesse_x;  	    //longitudinal speed (in km/h)
  double vitesse_y;			//tranversal speed (in km/h)
  
   /////////////////////front left wheel/////////////// 
  double fx_AVG;         //longitudinal force of the front left wheel (in mv/N)
  double fy_AVG;			//vertical force of the front left wheel (in mv/N)
  double fz_AVG;			//lateral force of the front left wheel (in mv/N)
  double mx_AVG;         //longitudinal moment of the front left wheel (in mv/N)
  double my_AVG;			//vertical moment of the front left wheel (in mv/N.m)
  double mz_AVG;			//lateral moment of the front left wheel (in mv/N.m)
  double angle_AVG;			//front left wheel angle (v/deg)
  double omega_AVG;			//angular velociet of the front left wheel (in vs/deg)
  
/////////////////////rear left wheel/////////////// 
  double fx_ARG;         //longitudinal force of the rear left wheel (in mv/N)
  double fy_ARG;			//vertical force of the rear left wheel (in mv/N)
  double fz_ARG;			//lateral force of the rear left wheel (in mv/N)
  double mx_ARG;			//longitudinal moment of the rear left wheel (in mv/N)
  double my_ARG;			//vertical moment of the rear left wheel (in mv/N)
  double mz_ARG; 		//lateral moment of the rear left wheel (in mv/N)
  double angle_ARG;			//rear left wheel angle (v/deg)
  double omega_ARG;			//angular velociet of the rear left wheel (in vs/deg)
  
   /////////////////////front right wheel/////////////// 
  double fx_AVD;         //longitudinal force of the front right wheel (in mv/N)
  double fy_AVD;			//vertical force of the front right wheel (in mv/N)
  double fz_AVD;			//lateral force of the front right wheel (in mv/N)
  double mx_AVD;			//longitudinal moment of the front right wheel (in mv/N)
  double my_AVD;			//vertical moment of the front right wheel (in mv/N)
  double mz_AVD; 		//lateral moment of the front right wheel (in mv/N)
  double angle_AVD;			//front right wheel angle (v/deg)
  double omega_AVD;			//angular velociet of the front right wheel (in vs/deg)
  
   /////////////////////rear left wheel/////////////// 
  double fx_ARD;         //longitudinal force of the rear right wheel (in mv/N)
  double fy_ARD;			//vertical force of the rear right wheel (in mv/N)
  double fz_ARD;			//lateral force of the rear right wheel (in mv/N)
  double mx_ARD;			//longitudinal moment of the rear right wheel (in mv/N)
  double my_ARD;			//vertical moment of the rear right wheel (in mv/N)
  double mz_ARD; 		//lateral moment of the rear right wheel (in mv/N)
  double angle_ARD;			//rear right wheel angle (v/deg)
  double omega_ARD;			//angular velociet of the rear right wheel (in vs/deg)
  
};

#endif