/// Data structures for Radar TRW

#ifndef STRUCTURERADAR_H
#define STRUCTURERADAR_H

#include "kernel/road_time.h"

#define NB_TARGET 12
#define NB_TRACK 8

typedef struct
{
    int32_t IIV;
    int32_t NLIV;
    float Range;
    float VRel;
    float Det_Lvl;
    int32_t ID;
    int32_t Cred;
    int32_t Sel_Stat;
    int32_t Tr_Stat;
    int32_t CWS;
    float Tr_LD;
    float UAng;
    int32_t Ta_Idx;
    float TaLd;
} DONNEE_TRACK;

typedef struct
{
    int32_t ID;
    float Range;
    float VRel;
    float Det_Lvl;
    float RelAz;
    int8_t AStat;
    int8_t ndId;
    int32_t R123;
    int32_t R1234;
    int32_t R12;
    float N21_1;
    int32_t LinErr;
} DONNEE_TARGET;

typedef struct
{
    DONNEE_TRACK Tracks[NB_TRACK];
    DONNEE_TARGET Targets[NB_TARGET];
} DONNEE_RADAR;

typedef struct
{
	DONNEE_RADAR donnees_radar;
	road_time_t t;
	road_timerange_t tr;
} RECORD_RADAR;

#endif // STRUCTURERADAR_H
