/*********************************************************************
//  created:    2007/11/02 - 17:42
//  filename:   AlascaDataGenerator.h
//
//  author:     Gerald Dherbomez 
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Generates raw data of Alasca sensor for testing purpose
*********************************************************************/

// FIXME: should be unsigned char? Otherwise values from 0x80 (128) up to 0xFF (255) are truncated and transformed into 0x00 (0) up to 0x7F (127) (lost first bit)
const char alascaData[1] = {0xAF};
/*
// The Alasca data
// FIXME: should be unsigned char?
const char alascaData[18696] = {
  
	0xAF, 0xFE, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0xA8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x12, 0x8C, 
	0x01, 0x80, 0x0A, 0xC4, 0x00, 0x08, 0x12, 0x76, 0x09, 0x01, 0x00, 0x7F, 0x34, 0x00, 0x00, 0x00, 
	0x21, 0x03, 0x05, 0xB3, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0E, 0x80, 0x7F, 0x0F, 
	0x03, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0x01, 0x32, 0xAF, 0x00, 
	0x06, 0x07, 0xD1, 0x3E, 0x9D, 0xF4, 0x4F, 0xA6, 0x06, 0x27, 0xD2, 0x3E, 0x91, 0xF4, 0x8F, 0xA4, 
	0x06, 0x47, 0xD2, 0x3E, 0x89, 0xF4, 0x8F, 0xA1, 0x06, 0x67, 0xD2, 0xBE, 0x85, 0xF4, 0xAF, 0xA0, 
	0x06, 0x87, 0xD2, 0xBE, 0x81, 0xF4, 0x8F, 0x9F, 0x06, 0xA7, 0xD2, 0xBE, 0x7D, 0xF4, 0x8F, 0x9D, 
	0x06, 0xC7, 0xD2, 0x3E, 0x71, 0xF4, 0x8F, 0x9B, 0x06, 0xE7, 0xD3, 0x3E, 0x5F, 0xFF, 0xFF, 0xFF, 
	0x05, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x04, 0x00, 0x03, 0x02, 0x80, 0x7F, 0x0F, 
	0x0B, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0x01, 0x13, 0x00, 0x00, 
	0x0E, 0x07, 0xE8, 0x3D, 0x6D, 0xF6, 0xAF, 0x61, 0x0E, 0x27, 0xDE, 0xBC, 0xD3, 0xFF, 0xFF, 0xFF, 
	0x07, 0x00, 0x00, 0xC4, 0x00, 0x00, 0x44, 0x9F, 0xAF, 0xFE, 0xC0, 0xC0, 0x00, 0x00, 0x1F, 0xB4, 
	0x00, 0x00, 0x00, 0x0F, 0x00, 0x08, 0x12, 0x8C, 0x01, 0x03, 0x06, 0x00, 0x00, 0x08, 0x12, 0x87, 
	0x33, 0x22, 0xCC, 0xDF, 0x32, 0xBB, 0x02, 0xA3, 0x49, 0x01, 0x00, 0x04, 0x00, 0x0B, 0x00, 0x29, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x2D, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x04, 
	0x00, 0x0A, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x28, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x26, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x04, 0x00, 0x0D, 0x00, 0x29, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x04, 
	0x00, 0x0A, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x25, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x27, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x28, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x0E, 0x00, 0x25, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x24, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x27, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x21, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x0F, 0x00, 0x24, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x1E, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x10, 0x00, 0x25, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x10, 0x00, 0x24, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x1E, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x10, 0x00, 0x21, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x11, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x12, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x1D, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x11, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x13, 0x00, 0x24, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x12, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x23, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x15, 0x00, 0x26, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x15, 0x00, 0x24, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x14, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x16, 0x00, 0x25, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x18, 0x00, 0x28, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x16, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x25, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x17, 0x00, 0x24, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x24, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x23, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x16, 0x00, 0x21, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x22, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x24, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x23, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x16, 0x00, 0x21, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x21, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x24, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x16, 0x00, 0x20, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x21, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x23, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x17, 0x00, 0x20, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x21, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x23, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x18, 0x00, 0x20, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x20, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x1D, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1E, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x21, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1E, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x19, 0x00, 0x1E, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x19, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x20, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x16, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x19, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x1D, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x19, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1A, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x18, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x1A, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x14, 0x00, 0x16, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x17, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x19, 0x00, 0x19, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x18, 0x00, 0x19, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x17, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x16, 0x00, 0x16, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x16, 0x00, 0x16, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x16, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x17, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x17, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x16, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x16, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x17, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x19, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1D, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x18, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x1A, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1F, 0x00, 0x1B, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x18, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x18, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x19, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x20, 0x00, 0x1B, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x1A, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x19, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x15, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x18, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x18, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x18, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x14, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x17, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x17, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x18, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1F, 0x00, 0x17, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x21, 0x00, 0x19, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x1B, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x18, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x15, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x16, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x14, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x22, 0x00, 0x18, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x20, 0x00, 0x17, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x16, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x17, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1C, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x15, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x14, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x16, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1F, 0x00, 0x14, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x0F, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x11, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x15, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x20, 0x00, 0x14, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x11, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x12, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x15, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x20, 0x00, 0x13, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x11, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x14, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x0E, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x20, 0x00, 0x12, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0x00, 0x13, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x11, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x0D, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x21, 0x00, 0x12, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x24, 0x00, 0x13, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0D, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x20, 0x00, 0x11, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x20, 0x00, 0x11, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0C, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x24, 0x00, 0x12, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x0E, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x0C, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x0D, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x0C, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0B, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1D, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x26, 0x00, 0x0F, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x23, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0x00, 0x0E, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x0A, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x23, 0x00, 0x0D, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x16, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x0A, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x26, 0x00, 0x0E, 0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x0B, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x23, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x0A, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x20, 0x00, 0x0A, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x07, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x08, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x0B, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x27, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x07, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x28, 0x00, 0x0C, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x08, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x24, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x0A, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x07, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x27, 0x00, 0x0B, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x25, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x07, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x27, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x24, 0x00, 0x09, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x06, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x09, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x28, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x09, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x24, 0x00, 0x09, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x07, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x06, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x09, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x24, 0x00, 0x08, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1C, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0x00, 0x07, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1C, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x08, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0x00, 0x07, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x28, 0x00, 0x08, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x25, 0x00, 0x07, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x06, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x25, 0x00, 0x07, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x05, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0x00, 0x06, 0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x29, 0x00, 0x08, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x07, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x05, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x06, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x25, 0x00, 0x06, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x22, 0x00, 0x06, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x05, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x06, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x25, 0x00, 0x06, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x04, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x05, 0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x04, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x05, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x04, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x04, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0x00, 0x04, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x26, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x04, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x04, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x04, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x04, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x04, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x04, 0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x03, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x04, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x26, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x03, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x03, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x26, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x26, 0x00, 0x03, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x02, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x02, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x02, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x02, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0x00, 0x02, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x02, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x02, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x01, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x02, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1F, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x01, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x01, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x26, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xFF, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFF, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1E, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFF, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFE, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0xFF, 0xFE, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFE, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xFE, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFE, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFE, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0xFF, 0xFD, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFE, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFE, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFD, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFD, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFD, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0xFF, 0xFE, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFD, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFD, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFD, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFC, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFD, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFC, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0xFF, 0xFB, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFC, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xFC, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFC, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x26, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFB, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFC, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x26, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFC, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFC, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFB, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1E, 0xFF, 0xFB, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x26, 0xFF, 0xFA, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1E, 0xFF, 0xFB, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x25, 0xFF, 0xF9, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFA, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x25, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x25, 0xFF, 0xF9, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xFA, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x25, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFA, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xF9, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x25, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFA, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1E, 0xFF, 0xFA, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x25, 0xFF, 0xF8, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xFA, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x25, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xF9, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1E, 0xFF, 0xF9, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF9, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1E, 0xFF, 0xF9, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFA, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF9, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF9, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF9, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF8, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xF8, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF8, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1E, 0xFF, 0xF8, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF8, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF8, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xF8, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF7, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF7, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xF7, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF7, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF7, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x19, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF7, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF7, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xF4, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xF7, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF6, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF6, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x20, 0xFF, 0xF5, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF6, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF6, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x20, 0xFF, 0xF5, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xF3, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF5, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xF4, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x19, 0xFF, 0xF7, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xF4, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF5, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xF4, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x19, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xF2, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF4, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xF3, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x19, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xF1, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF4, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xF2, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x18, 0xFF, 0xF5, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xF0, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF3, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF4, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xF3, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xF1, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF4, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF2, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xF3, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF3, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF3, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF2, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xF2, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xF2, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF3, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF1, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1E, 0xFF, 0xF0, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF2, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF1, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xF1, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x22, 0xFF, 0xED, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xEF, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF2, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xF0, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xF1, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF1, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF1, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xF0, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xF0, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xEE, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF1, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xEF, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xEE, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF0, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xEF, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x18, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xE9, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xEF, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xEE, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xED, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xEE, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xED, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xEC, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xEE, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xE9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x17, 0xFF, 0xEF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xED, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xE7, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xE9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0xFF, 0xEC, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xE8, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0xFF, 0xEE, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xE9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xEA, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xE8, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0x03, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xE7, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xE7, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xEC, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0x03, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x21, 0xFF, 0xE4, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xEA, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xE7, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0x03, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x20, 0xFF, 0xE3, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xE7, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0xFF, 0xEB, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0x03, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x19, 0xFF, 0xE9, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xE3, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xE6, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xE9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x19, 0xFF, 0xE8, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xE2, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xE7, 0x00, 0x01, 0x00, 0x03, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0x03, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x18, 0xFF, 0xE8, 0xFF, 0xFF, 0x00, 0x03, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xE3, 
	0x00, 0x00, 0x00, 0x03, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xE4, 0x00, 0x01, 0x00, 0x03, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xE8, 0x00, 0x00, 0x00, 0x03, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xE4, 0x00, 0x00, 0x00, 0x03, 0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0xFF, 0xE9, 
	0xFF, 0xFF, 0x00, 0x03, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xE5, 0x00, 0x01, 0x00, 0x02, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x16, 0xFF, 0xE9, 0x00, 0x00, 0x00, 0x02, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x16, 0xFF, 0xE8, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xE0, 
	0x00, 0x00, 0x00, 0x03, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xE7, 0x00, 0x00, 0x00, 0x03, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xE3, 0x00, 0x01, 0x00, 0x03, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xE3, 0xFF, 0xFF, 0x00, 0x03, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xE5, 
	0x00, 0x00, 0x00, 0x03, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xDF, 0x00, 0x00, 0x00, 0x03, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xE1, 0xFF, 0xFF, 0x00, 0x03, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1E, 0xFF, 0xDE, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xDC, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xDE, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xD8, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xDC, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xDB, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xDD, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xD7, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xDF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xDA, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xE2, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xDB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x21, 0xFF, 0xD6, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xD9, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xDC, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xDB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x21, 0xFF, 0xD6, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xD9, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xDB, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xDA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x20, 0xFF, 0xD5, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xD8, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xD7, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xDA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xD5, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x01, 0x00, 0x01, 0x0B, 0xFE, 0x8B, 
	0xFF, 0xFA, 0x00, 0x02, 0x49, 0x03, 0x00, 0x04, 0x00, 0x1C, 0xFF, 0xD9, 0x00, 0x01, 0x00, 0x03, 
	0x49, 0x00, 0x00, 0x04, 0x00, 0x1A, 0xFF, 0xDA, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x01, 0x00, 
	0x00, 0xF2, 0xFE, 0xAA, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x01, 0x00, 0x04, 0x00, 0x16, 0xFF, 0xE0, 
	0x00, 0x00, 0x00, 0x03, 0x49, 0x02, 0x00, 0x04, 0x00, 0x20, 0xFF, 0xD1, 0x00, 0x00, 0x00, 0x03, 
	0x49, 0x00, 0x01, 0x00, 0x00, 0xF1, 0xFE, 0xA2, 0xFF, 0xFB, 0x00, 0x02, 0x49, 0x03, 0x00, 0x04, 
	0x00, 0x19, 0xFF, 0xDB, 0x00, 0x01, 0x00, 0x02, 0x49, 0x00, 0x00, 0x04, 0x00, 0x1C, 0xFF, 0xD7, 
	0xFF, 0xFF, 0x00, 0x03, 0x49, 0x01, 0x01, 0x00, 0x00, 0xF2, 0xFE, 0x9C, 0xFF, 0xFF, 0x00, 0x02, 
	0x49, 0x02, 0x00, 0x04, 0x00, 0x19, 0xFF, 0xDB, 0x00, 0x00, 0x00, 0x02, 0x49, 0x02, 0x01, 0x00, 
	0x01, 0x0E, 0xFE, 0x6A, 0x00, 0x01, 0x00, 0x02, 0x49, 0x01, 0x00, 0x04, 0x00, 0x15, 0xFF, 0xE0, 
	0x00, 0x00, 0x00, 0x02, 0x49, 0x00, 0x01, 0x00, 0x00, 0xF2, 0xFE, 0x93, 0xFF, 0xFB, 0x00, 0x02, 
	0x49, 0x03, 0x01, 0x00, 0x00, 0xF6, 0xFE, 0x8A, 0x00, 0x05, 0x00, 0x02, 0x49, 0x00, 0x00, 0x04, 
	0x00, 0x19, 0xFF, 0xDA, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x01, 0x02, 0x00, 0x00, 0xEF, 0xFE, 0x93, 
	0xFF, 0xFF, 0x00, 0x02, 0x49, 0x02, 0x01, 0x00, 0x00, 0xF7, 0xFE, 0x7F, 0x00, 0x01, 0x00, 0x02, 
	0x49, 0x01, 0x00, 0x04, 0x00, 0x13, 0xFF, 0xE2, 0x00, 0x00, 0x00, 0x01, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0xF2, 0xFE, 0x85, 0xFF, 0xFB, 0x00, 0x02, 0x49, 0x03, 0x00, 0x00, 0x00, 0xF6, 0xFE, 0x7B, 
	0x00, 0x05, 0x00, 0x02, 0x49, 0x00, 0x00, 0x04, 0x00, 0x19, 0xFF, 0xD8, 0xFF, 0xFF, 0x00, 0x01, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0xF1, 0xFE, 0x81, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0xF5, 0xFE, 0x73, 0x00, 0x01, 0x00, 0x02, 0x49, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFE, 0x79, 
	0xFF, 0xFB, 0x00, 0x02, 0x49, 0x01, 0x01, 0x04, 0x00, 0x11, 0xFF, 0xE4, 0x00, 0x00, 0x00, 0x00, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0xF4, 0xFE, 0x70, 0x00, 0x05, 0x00, 0x02, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0xEF, 0xFE, 0x76, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x02, 0x00, 0x00, 0x00, 0xF6, 0xFE, 0x62, 
	0x00, 0x01, 0x00, 0x02, 0x49, 0x00, 0x00, 0x00, 0x00, 0xF2, 0xFE, 0x66, 0xFF, 0xFB, 0x00, 0x02, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0xF1, 0xFE, 0x62, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0xF5, 0xFE, 0x55, 0x00, 0x05, 0x00, 0x02, 0x49, 0x00, 0x00, 0x00, 0x00, 0xF2, 0xFE, 0x55, 
	0xFF, 0xFB, 0x00, 0x02, 0x49, 0x01, 0x00, 0x00, 0x00, 0xF3, 0xFE, 0x4E, 0xFF, 0xFF, 0x00, 0x02, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0xF6, 0xFE, 0x47, 0x00, 0x01, 0x00, 0x02, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0xF9, 0xFE, 0x36, 0xFF, 0xFB, 0x00, 0x02, 0x49, 0x03, 0x00, 0x00, 0x00, 0xF8, 0xFE, 0x2B, 
	0x00, 0x05, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0xEE, 0xFE, 0x32, 0xFF, 0xFF, 0x00, 0x03, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0xF2, 0xFE, 0x28, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0xEB, 0xFE, 0x29, 0xFF, 0xFB, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0xE8, 0xFE, 0x22, 
	0x00, 0x05, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0xD3, 0xFE, 0x40, 0xFF, 0xFF, 0x00, 0x03, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0xD8, 0xFE, 0x35, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0xCD, 0xFE, 0x3D, 0xFF, 0xFC, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0xCF, 0xFE, 0x2D, 
	0x00, 0x04, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0xCA, 0xFE, 0x2A, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0xCC, 0xFE, 0x23, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0xC7, 0xFE, 0x20, 0xFF, 0xFC, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0xC6, 0xFE, 0x14, 
	0x00, 0x04, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0xC6, 0xFE, 0x04, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0xC6, 0xFD, 0xFF, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0xC0, 0xFD, 0xFF, 0xFF, 0xFC, 0x00, 0x03, 0x49, 0x03, 0x00, 0x00, 0x00, 0xBF, 0xFD, 0xF0, 
	0x00, 0x04, 0x00, 0x02, 0x49, 0x01, 0x01, 0x00, 0x00, 0xB7, 0xFD, 0xF3, 0xFF, 0xFF, 0x00, 0x01, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x6C, 0xFE, 0xC9, 0x00, 0x00, 0x00, 0x01, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0xBB, 0xFD, 0xE5, 0x00, 0x01, 0x00, 0x02, 0x49, 0x00, 0x00, 0x00, 0x00, 0x6A, 0xFE, 0xC2, 
	0xFF, 0xFE, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x68, 0xFE, 0xBE, 0x00, 0x02, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0xA6, 0xFD, 0xEA, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x62, 0xFE, 0xC2, 0x00, 0x00, 0x00, 0x01, 0x49, 0x02, 0x01, 0x00, 0x00, 0xA7, 0xFD, 0xE3, 
	0x00, 0x01, 0x00, 0x03, 0x49, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xFD, 0xE6, 0xFF, 0xFD, 0x00, 0x02, 
	0x49, 0x01, 0x01, 0x00, 0x00, 0x92, 0xFD, 0xE7, 0xFF, 0xFF, 0x00, 0x01, 0xAF, 0xFE, 0xC0, 0xC0, 
	0x00, 0x00, 0x08, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x08, 0x12, 0x8C, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0x0B, 0x00, 0x29, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x2D, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x04, 0x00, 0x0A, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x04, 
	0x00, 0x0C, 0x00, 0x28, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x26, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x04, 0x00, 0x0D, 0x00, 0x29, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x04, 0x00, 0x0A, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x0D, 0x00, 0x25, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x27, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x28, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x25, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x0E, 0x00, 0x24, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x27, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x21, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x24, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x0D, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x1F, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x10, 0x00, 0x25, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x10, 0x00, 0x24, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x0E, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x10, 0x00, 0x21, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x11, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x12, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x0F, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x11, 0x00, 0x20, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x13, 0x00, 0x24, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x12, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x13, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x15, 0x00, 0x26, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x15, 0x00, 0x24, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x14, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x16, 0x00, 0x25, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x22, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x18, 0x00, 0x28, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x16, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x25, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x17, 0x00, 0x24, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x24, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x16, 0x00, 0x21, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x22, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x24, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x16, 0x00, 0x21, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x21, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x19, 0x00, 0x24, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x16, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x23, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x21, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x19, 0x00, 0x23, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x22, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x21, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x23, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x22, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x20, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x1D, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x20, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x21, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x20, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x19, 0x00, 0x1E, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x19, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x15, 0x00, 0x19, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x20, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x16, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x19, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x16, 0x00, 0x19, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x1D, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x19, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x1A, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x18, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1A, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x14, 0x00, 0x16, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x17, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x19, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x18, 0x00, 0x19, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x17, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x16, 0x00, 0x16, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x16, 0x00, 0x16, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x16, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x17, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x17, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x18, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x16, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x16, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x17, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x19, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x18, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x1A, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x1B, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x18, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x18, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x19, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x20, 0x00, 0x1B, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1F, 0x00, 0x1A, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x19, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x15, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x18, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1D, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x18, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x18, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x14, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x17, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x17, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x18, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x17, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x21, 0x00, 0x19, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x1B, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x18, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x15, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x16, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x14, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x18, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x20, 0x00, 0x17, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x16, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x17, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1F, 0x00, 0x15, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x14, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x16, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x14, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x0F, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x11, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x15, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x14, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1C, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x12, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x15, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x13, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x11, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x14, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x0E, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x12, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x23, 0x00, 0x13, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x11, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x0D, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0x00, 0x12, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x24, 0x00, 0x13, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x10, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0D, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x11, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x20, 0x00, 0x11, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0x00, 0x10, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0C, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x24, 0x00, 0x12, 0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x0E, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x0C, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x0E, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0xAF, 0xFE, 0xC0, 0xC0, 
	0x00, 0x00, 0x00, 0xA8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x12, 0xB4, 0x01, 0x80, 0x0A, 0xC5, 
	0x00, 0x08, 0x12, 0x9E, 0x09, 0x01, 0x00, 0x7F, 0x34, 0x00, 0x00, 0x00, 0x21, 0x03, 0x05, 0xB3, 
	0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0E, 0x80, 0x7F, 0x0F, 0x03, 0xFF, 0x00, 0x00, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x04, 0xFF, 0xFF, 0xFF, 0x01, 0x32, 0xB0, 0x00, 0x06, 0x07, 0xD1, 0x3E, 
	0x9D, 0xF4, 0x4F, 0xA5, 0x06, 0x27, 0xD2, 0x3E, 0x91, 0xF4, 0x8F, 0xA4, 0x06, 0x47, 0xD2, 0x3E, 
	0x89, 0xF4, 0x8F, 0xA1, 0x06, 0x67, 0xD2, 0xBE, 0x85, 0xF4, 0xAF, 0xA0, 0x06, 0x87, 0xD2, 0xBE, 
	0x81, 0xF4, 0x8F, 0x9F, 0x06, 0xA7, 0xD2, 0xBE, 0x79, 0xF4, 0x8F, 0x9D, 0x06, 0xC7, 0xD2, 0x3E, 
	0x71, 0xF4, 0x6F, 0x9C, 0x06, 0xE7, 0xD2, 0xBE, 0x63, 0xFF, 0xFF, 0xFF, 0x05, 0x01, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0A, 0x04, 0x00, 0x03, 0x02, 0x80, 0x7F, 0x0F, 0x0B, 0xFF, 0x00, 0x00, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xFF, 0xFF, 0xFF, 0x01, 0x13, 0x01, 0x00, 0x0E, 0x07, 0xE8, 0x3D, 
	0x6D, 0xF6, 0xAF, 0x61, 0x0E, 0x27, 0xDE, 0xBC, 0xD3, 0xFF, 0xFF, 0xFF, 0x07, 0x00, 0x00, 0xC5, 
	0x00, 0x00, 0x45, 0x2A, 0xAF, 0xFE, 0xC0, 0xC0, 0x00, 0x00, 0x1F, 0xB4, 0x00, 0x00, 0x00, 0x0F, 
	0x00, 0x08, 0x12, 0xB4, 0x01, 0x03, 0x06, 0x00, 0x00, 0x08, 0x12, 0xAF, 0x33, 0x22, 0xCC, 0xDF, 
	0x32, 0xBC, 0x02, 0xA3, 0x49, 0x01, 0x00, 0x04, 0x00, 0x0B, 0x00, 0x29, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x2D, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x04, 
	0x00, 0x0C, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x04, 0x00, 0x0B, 0x00, 0x26, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x28, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x04, 0x00, 0x0B, 0x00, 0x25, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x04, 
	0x00, 0x0D, 0x00, 0x28, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x23, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x25, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x28, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x0D, 0x00, 0x25, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x25, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x24, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x27, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x0D, 0x00, 0x21, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x24, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x21, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x0E, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x10, 0x00, 0x24, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x10, 0x00, 0x21, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x0D, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x12, 0x00, 0x23, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x14, 0x00, 0x26, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x10, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x12, 0x00, 0x22, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x15, 0x00, 0x25, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x15, 0x00, 0x25, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x14, 0x00, 0x22, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x16, 0x00, 0x25, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x28, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x16, 0x00, 0x23, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x26, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x17, 0x00, 0x25, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x15, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x23, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x25, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x16, 0x00, 0x21, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x16, 0x00, 0x21, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x24, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x16, 0x00, 0x21, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x21, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x19, 0x00, 0x24, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x16, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x23, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x15, 0x00, 0x1E, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x19, 0x00, 0x22, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x17, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x20, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x20, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x18, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x22, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x20, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x22, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x21, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x21, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x1F, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x1E, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x19, 0x00, 0x1E, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x19, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x1B, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x19, 0x00, 0x1D, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x1B, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x18, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x19, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1A, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x18, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x19, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x1A, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x17, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x16, 0x00, 0x17, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x16, 0x00, 0x16, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x17, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x16, 0x00, 0x16, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x19, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x16, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x16, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x17, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x16, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x16, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x17, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x19, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1C, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x1A, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x18, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x17, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1D, 0x00, 0x1A, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x18, 0x00, 0x15, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x1B, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x18, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x19, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x20, 0x00, 0x1B, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x17, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x19, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x15, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0x00, 0x1B, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x15, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x21, 0x00, 0x19, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x14, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x18, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x17, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1D, 0x00, 0x16, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x21, 0x00, 0x19, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x19, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x17, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1D, 0x00, 0x15, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x18, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x21, 0x00, 0x18, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x16, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x20, 0x00, 0x16, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x18, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x20, 0x00, 0x17, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x19, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x22, 0x00, 0x17, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x15, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x14, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x22, 0x00, 0x16, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x13, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x14, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x13, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x22, 0x00, 0x15, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x13, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x12, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x22, 0x00, 0x15, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x16, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0x00, 0x14, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0E, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x12, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0x00, 0x13, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x0D, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x12, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0x00, 0x13, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0D, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x20, 0x00, 0x11, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x0C, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0x00, 0x12, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0C, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x21, 0x00, 0x11, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x0E, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x24, 0x00, 0x12, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x0C, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x24, 0x00, 0x11, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0x00, 0x0F, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x16, 0x00, 0x09, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x19, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x25, 0x00, 0x10, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x0E, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x23, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0x00, 0x0E, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x16, 0x00, 0x09, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x0A, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x23, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x0A, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x20, 0x00, 0x0B, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x23, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x09, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x09, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x27, 0x00, 0x0D, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x09, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x17, 0x00, 0x07, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x0B, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x08, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x27, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x24, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x24, 0x00, 0x0B, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x07, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1C, 0x00, 0x08, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x27, 0x00, 0x0B, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x27, 0x00, 0x0B, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x06, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x0A, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x24, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x25, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x24, 0x00, 0x09, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x06, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x09, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1C, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x28, 0x00, 0x0A, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x09, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x24, 0x00, 0x09, 0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x21, 0x00, 0x08, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x06, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x24, 0x00, 0x09, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x24, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x24, 0x00, 0x08, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x25, 0x00, 0x08, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x06, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0x00, 0x07, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x28, 0x00, 0x08, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x07, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1D, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x07, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x25, 0x00, 0x07, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x21, 0x00, 0x06, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x07, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x28, 0x00, 0x07, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x06, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x06, 0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x29, 0x00, 0x07, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x06, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x05, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x06, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x04, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x21, 0x00, 0x05, 0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x04, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x04, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x05, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x04, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0x00, 0x04, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x05, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x04, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x21, 0x00, 0x04, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x03, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x22, 0x00, 0x04, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0x00, 0x04, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x04, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x04, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x03, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x03, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x26, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x26, 0x00, 0x03, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x03, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x02, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x03, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x02, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x23, 0x00, 0x02, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x02, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x02, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x02, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x02, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x01, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x01, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x01, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xFF, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFF, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFE, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFE, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xFE, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFE, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFE, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFE, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xFD, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFD, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFD, 0x00, 0x01, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1E, 0xFF, 0xFD, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFD, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFD, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFC, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xFC, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0xFF, 0xFB, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFC, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFC, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFC, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFC, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFB, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFC, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFC, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x26, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFC, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x22, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFC, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFB, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xFB, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFB, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1E, 0xFF, 0xFB, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0xFF, 0xF9, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFB, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x25, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFA, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xFA, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFB, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFA, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x25, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFA, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xF9, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x21, 0xFF, 0xF9, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0xFF, 0xF8, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xFA, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xFA, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xF9, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x25, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xF9, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF9, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1E, 0xFF, 0xF9, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xFA, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF9, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xF9, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF9, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF8, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF8, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF8, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF8, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF8, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF8, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xF8, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF9, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF7, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x20, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF7, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF7, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xF7, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF7, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF7, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xF7, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF7, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF6, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xF6, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xF4, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF7, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF6, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x19, 0xFF, 0xF7, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xF3, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xF3, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF6, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xF5, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF7, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xF2, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF5, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xF5, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF6, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xF2, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF4, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x19, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x25, 0xFF, 0xF0, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xF1, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF4, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xF2, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xF5, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xF1, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF3, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x19, 0xFF, 0xF4, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xF1, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF4, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xF2, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF3, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF3, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF3, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xF2, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF2, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xF3, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xF1, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xF0, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF2, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xF1, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x21, 0xFF, 0xEE, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xF1, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xF1, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF2, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xF0, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xEF, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF1, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xF0, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xF0, 0x00, 0x01, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xEC, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xEE, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xF1, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xEF, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xF0, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x23, 0xFF, 0xEA, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xEF, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x20, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xED, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xEF, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xED, 
	0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xEF, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xEE, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1B, 0xFF, 0xED, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xEC, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xEE, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1F, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0xFF, 0xEF, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xED, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xE7, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xE9, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xEC, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xE8, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xE9, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xE8, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xEC, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xE5, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xE7, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xEC, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1A, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xE3, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xEA, 0xFF, 0xFF, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xE7, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x19, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0x03, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xE9, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xE3, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xE7, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x19, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xE9, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xE3, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xE6, 0x00, 0x01, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x18, 0xFF, 0xE9, 0x00, 0x00, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xE8, 
	0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xE2, 0x00, 0x00, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xE4, 0x00, 0x01, 0x00, 0x03, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x17, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0x03, 0x49, 0x00, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xE9, 
	0xFF, 0xFF, 0x00, 0x03, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xE3, 0x00, 0x00, 0x00, 0x03, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xE4, 0x00, 0x01, 0x00, 0x03, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xE4, 0x00, 0x00, 0x00, 0x03, 0x49, 0x00, 0x00, 0x00, 0x00, 0x17, 0xFF, 0xE9, 
	0xFF, 0xFF, 0x00, 0x03, 0x49, 0x01, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xED, 0x00, 0x00, 0x00, 0x03, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xE5, 0x00, 0x01, 0x00, 0x03, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x16, 0xFF, 0xE9, 0x00, 0x00, 0x00, 0x02, 0x49, 0x00, 0x00, 0x00, 0x00, 0x16, 0xFF, 0xE8, 
	0xFF, 0xFF, 0x00, 0x02, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x03, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0x17, 0xFF, 0xE7, 0x00, 0x00, 0x00, 0x03, 0x49, 0x03, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xE3, 0x00, 0x01, 0x00, 0x03, 0x49, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFF, 0xE4, 
	0xFF, 0xFF, 0x00, 0x03, 0x49, 0x01, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xE5, 0x00, 0x00, 0x00, 0x03, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xDD, 0x00, 0x00, 0x00, 0x03, 0x49, 0x00, 0x00, 0x00, 
	0x00, 0x1B, 0xFF, 0xE1, 0xFF, 0xFF, 0x00, 0x03, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xDE, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xDC, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xDE, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x22, 0xFF, 0xD8, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xDD, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xDB, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xDD, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0x20, 0xFF, 0xDA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xDC, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xDA, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xDC, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xDB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x22, 0xFF, 0xD6, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xD9, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xDC, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1D, 0xFF, 0xDB, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x21, 0xFF, 0xD6, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xD9, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0xDB, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xDA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xD5, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xD8, 0x00, 0x01, 0x00, 0x04, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x20, 0xFF, 0xD5, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x1C, 0xFF, 0xDA, 0x00, 0x00, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xD5, 
	0x00, 0x00, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0x19, 0xFF, 0xDD, 0x00, 0x01, 0x00, 0x03, 
	0x49, 0x00, 0x01, 0x00, 0x01, 0x08, 0xFE, 0x90, 0xFF, 0xFA, 0x00, 0x02, 0x49, 0x00, 0x00, 0x04, 
	0x00, 0x1A, 0xFF, 0xDA, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x01, 0x01, 0x00, 0x00, 0xF3, 0xFE, 0xA8, 
	0xFF, 0xFF, 0x00, 0x02, 0x49, 0x02, 0x00, 0x04, 0x00, 0x1C, 0xFF, 0xD8, 0x00, 0x00, 0x00, 0x03, 
	0x49, 0x01, 0x00, 0x04, 0x00, 0x16, 0xFF, 0xE1, 0x00, 0x00, 0x00, 0x03, 0x49, 0x00, 0x01, 0x00, 
	0x00, 0xF6, 0xFE, 0x9C, 0xFF, 0xFB, 0x00, 0x02, 0x49, 0x03, 0x00, 0x04, 0x00, 0x19, 0xFF, 0xDB, 
	0x00, 0x01, 0x00, 0x02, 0x49, 0x00, 0x00, 0x04, 0x00, 0x1C, 0xFF, 0xD7, 0xFF, 0xFF, 0x00, 0x03, 
	0x49, 0x01, 0x01, 0x00, 0x00, 0xF2, 0xFE, 0x9D, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x02, 0x00, 0x04, 
	0x00, 0x1A, 0xFF, 0xD9, 0x00, 0x00, 0x00, 0x02, 0x49, 0x02, 0x01, 0x00, 0x01, 0x0A, 0xFE, 0x70, 
	0x00, 0x01, 0x00, 0x02, 0x49, 0x01, 0x00, 0x04, 0x00, 0x15, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x02, 
	0x49, 0x00, 0x01, 0x00, 0x00, 0xF0, 0xFE, 0x96, 0xFF, 0xFB, 0x00, 0x02, 0x49, 0x03, 0x01, 0x00, 
	0x00, 0xF6, 0xFE, 0x8A, 0x00, 0x05, 0x00, 0x02, 0x49, 0x00, 0x00, 0x04, 0x00, 0x19, 0xFF, 0xDA, 
	0xFF, 0xFF, 0x00, 0x02, 0x49, 0x01, 0x01, 0x00, 0x00, 0xF1, 0xFE, 0x90, 0xFF, 0xFF, 0x00, 0x02, 
	0x49, 0x02, 0x01, 0x00, 0x00, 0xF7, 0xFE, 0x7F, 0x00, 0x01, 0x00, 0x02, 0x49, 0x01, 0x00, 0x04, 
	0x00, 0x13, 0xFF, 0xE2, 0x00, 0x00, 0x00, 0x01, 0x49, 0x00, 0x00, 0x00, 0x00, 0xF2, 0xFE, 0x85, 
	0xFF, 0xFB, 0x00, 0x02, 0x49, 0x03, 0x00, 0x00, 0x00, 0xF6, 0xFE, 0x7B, 0x00, 0x05, 0x00, 0x02, 
	0x49, 0x00, 0x00, 0x04, 0x00, 0x19, 0xFF, 0xD8, 0xFF, 0xFF, 0x00, 0x01, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0xF1, 0xFE, 0x81, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x02, 0x00, 0x00, 0x00, 0xF5, 0xFE, 0x74, 
	0x00, 0x01, 0x00, 0x02, 0x49, 0x00, 0x00, 0x00, 0x00, 0xF1, 0xFE, 0x78, 0xFF, 0xFB, 0x00, 0x02, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0xF4, 0xFE, 0x6F, 0x00, 0x05, 0x00, 0x02, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0xF1, 0xFE, 0x72, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x01, 0x00, 0x04, 0x00, 0x0F, 0xFF, 0xE8, 
	0x00, 0x00, 0x00, 0x01, 0x49, 0x02, 0x00, 0x00, 0x00, 0xF6, 0xFE, 0x62, 0x00, 0x01, 0x00, 0x02, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0xF2, 0xFE, 0x66, 0xFF, 0xFB, 0x00, 0x02, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0xEE, 0xFE, 0x68, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x03, 0x00, 0x00, 0x00, 0xF5, 0xFE, 0x55, 
	0x00, 0x05, 0x00, 0x02, 0x49, 0x00, 0x00, 0x00, 0x00, 0xF2, 0xFE, 0x55, 0xFF, 0xFB, 0x00, 0x02, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0xF4, 0xFE, 0x4C, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0xF3, 0xFE, 0x4D, 0x00, 0x01, 0x00, 0x02, 0x49, 0x00, 0x00, 0x00, 0x00, 0xF9, 0xFE, 0x36, 
	0xFF, 0xFB, 0x00, 0x02, 0x49, 0x03, 0x00, 0x00, 0x00, 0xF8, 0xFE, 0x2B, 0x00, 0x05, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0xEE, 0xFE, 0x31, 0xFF, 0xFF, 0x00, 0x03, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0xF2, 0xFE, 0x28, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0xEB, 0xFE, 0x29, 
	0xFF, 0xFB, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0xE8, 0xFE, 0x22, 0x00, 0x05, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0xD3, 0xFE, 0x40, 0xFF, 0xFF, 0x00, 0x03, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0xD6, 0xFE, 0x38, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0xCE, 0xFE, 0x3D, 
	0xFF, 0xFC, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0xCF, 0xFE, 0x2D, 0x00, 0x04, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0xCA, 0xFE, 0x2A, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0xCC, 0xFE, 0x23, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0xC7, 0xFE, 0x20, 
	0xFF, 0xFC, 0x00, 0x04, 0x49, 0x03, 0x00, 0x00, 0x00, 0xC6, 0xFE, 0x13, 0x00, 0x04, 0x00, 0x04, 
	0x49, 0x01, 0x00, 0x00, 0x00, 0xC4, 0xFE, 0x07, 0xFF, 0xFF, 0x00, 0x04, 0x49, 0x02, 0x00, 0x00, 
	0x00, 0xC6, 0xFD, 0xFF, 0x00, 0x01, 0x00, 0x04, 0x49, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xFD, 0xFF, 
	0xFF, 0xFC, 0x00, 0x03, 0x49, 0x03, 0x00, 0x00, 0x00, 0xBF, 0xFD, 0xF0, 0x00, 0x04, 0x00, 0x02, 
	0x49, 0x01, 0x01, 0x00, 0x00, 0xB8, 0xFD, 0xF1, 0xFF, 0xFF, 0x00, 0x01, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0x6C, 0xFE, 0xC9, 0x00, 0x00, 0x00, 0x01, 0x49, 0x02, 0x00, 0x00, 0x00, 0xBB, 0xFD, 0xE5, 
	0x00, 0x01, 0x00, 0x02, 0x49, 0x00, 0x00, 0x00, 0x00, 0x6A, 0xFE, 0xC2, 0xFF, 0xFE, 0x00, 0x04, 
	0x49, 0x03, 0x00, 0x00, 0x00, 0x68, 0xFE, 0xBE, 0x00, 0x02, 0x00, 0x04, 0x49, 0x01, 0x00, 0x00, 
	0x00, 0xA6, 0xFD, 0xEA, 0xFF, 0xFF, 0x00, 0x02, 0x49, 0x02, 0x00, 0x00, 0x00, 0x62, 0xFE, 0xC2, 
	0x00, 0x00, 0x00, 0x01, 0x49, 0x02, 0x01, 0x00, 0x00, 0xA8, 0xFD, 0xE0, 0x00, 0x01, 0x00, 0x03, 
	0x49, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xFD, 0xE6, 0xFF, 0xFD, 0x00, 0x02, 0x49, 0x01, 0x01, 0x00, 
	0x00, 0x92, 0xFD, 0xE7, 0xFF, 0xFF, 0x00, 0x01
};
*/

#include "AlascaSocket.h"

#include <QApplication>
#include <QThread>

namespace pacpus {

class AlascaDataGenerator
    : public QThread
{
public: 
    void run()
    {
        while (offset < 17000) {
            //LOG_INFO("press ENTER to decode data");
            // FIXME: this will crash with offset > 0 and commented `const char alascaData[18696]` !!!
            memcpy(frame.msg, alascaData + offset, frame.size); 
            offset += frame.size; 
            frame.time++; 
            send(generator); 
        }
        //LOG_WARN("there are no new data available\n"); 
    }

    AlascaDataGenerator(QObject * parent)
    {
        offset = 0; 
        frame.time = 0; 
        frame.size = 1000;
        // FIXME: where is delete[] frame.msg?
        frame.msg = new char[frame.size];
        generator = parent; 
        start(); 
    }

    ~AlascaDataGenerator()
    {
    }

    void send(QObject * receiver)
    {
        //LOG_DEBUG("new data sent"); 
        AlascaFrameEvent * e = new AlascaFrameEvent();
        e->frame = &frame; 
        QApplication::postEvent(receiver,e);  

        getchar(); 
    }

    AlascaFrame frame; // un structure determinant les donneees a emettre par l'event au prog de decodage customEvent
    int offset; 
    QObject *generator; 
};

} // namespace pacpus
