/*************************************************************************** 
*
* Copyright 2000 by David Demirdjian.   All rights reserved. 
*  
* Developed  by David Demirdjian
*  
* Permission to use, copy, or modify this software and  its documentation 
* for  educational  and  research purposes only and without fee  is hereby 
* granted, provided  that this copyright notice and the original authors's 
* names appear  on all copies and supporting documentation.  If individual 
* files are  separated from  this  distribution directory  structure, this 
* copyright notice must be included.  For any other uses of this software, 
* in original or  modified form, including but not limited to distribution 
* in whole or in  part, specific  prior permission  must be  obtained from 
* MIT.  These programs shall not  be  used, rewritten, or  adapted as  the 
* basis  of  a  commercial  software  or  hardware product  without  first 
* obtaining appropriate  licenses from David Demirdjian.  The author makes 
* no representations about the suitability of this software for any purpose.  
* It is provided "as is" without express or implied warranty. 
*  
**************************************************************************/
typedef unsigned char uchar;
typedef unsigned short ushort;
#include "processingMMX.h"
#include <math.h>


// Filter stereoBuffer for a given disparity ...
 //input:
 //- [ptBuff-backStep, ptBuff]       contains pixels filtered with sum_row
 //  [ptBuff, ptBuff+subImageSize]   contains raw pixels
 //- [ptBuff16, ptBuff16+2*backStep] contains pixels filtered with sum_row*avg_col
 //output:
 //- [ptBuff-backStep, ptBuff+subImageSize-backStep] contains filtered pixels
 //- [ptBuff16, ptBuff16+2*backStep] contains pixels filtered with sum_row*avg_col
void StereoBuffer::filterSAD(int maskX, int maskY, uchar* ptBuff, ushort* ptBuff16,
								 int backStep, int subImageSize, int offset)
{
	// ptBuff16 data from [0] to [backStep] come from previous iter
	// sum_Row_mmx fills ptBuff16 from [2*backStep] to [2*backStep+subImageSize]
	sum_Row_mmx(ptBuff , ptBuff16+2*backStep,	    subImageSize, maskX); 
	// avg_Col process data in ptBuff16 from [0] to [subImageSize]
	avg_Col_mmx(ptBuff16+backStep , ptBuff-backStep,subImageSize, width, maskY); 
	// then copy ptBuff16 data [subImageSize] to [2*backStep+subImageSize]
	// to [0] to [2*backStep] for next turn
	copyMMX(ptBuff16, ptBuff16+subImageSize, 2*backStep*sizeof(short));
	// init. SAD score
	//initMinimumCorrelation(ptBuff-backStep, 0,	imDepth+offset-backStep, 
	//						corrScore+offset-backStep,	
	//						corrScoreSec+offset-backStep, subImageSize);
}