#include "ShMemInterface.h"

#include "kernel/ComponentFactory.h"
#include "kernel/Log.h"
#include "PacpusTools/ShMem.h"
#include "Pacpus/kernel/PacpusEvent.h"
#include "Pacpus/kernel/inputOutputInterface.h"


using namespace std;
using namespace pacpus;

DECLARE_STATIC_LOGGER("pacpus.base.ShMemInput");

// Construct the factory
static ComponentFactory<ShMemInput> sFactory("ShMemInput");

void ShMemInput::addInputOutput()
{
    ADD_INPUT("data",ShMemInput,QByteArray,send);
}

//////////////////////////////////////////////////////////////////////////
/// Constructor.
ShMemInput::ShMemInput(QString name)
    : ComponentBase(name)
{   
    LOG_TRACE("constructor(" << name << ")");
    shMemSize_ = sizeof(size_t);
    shMemName_ = name; // default name
    addInputOutput();
}

//////////////////////////////////////////////////////////////////////////
/// Destructor.
ShMemInput::~ShMemInput()
{
    LOG_TRACE("destructor");

}

//////////////////////////////////////////////////////////////////////////
/// Called by the ComponentManager to start the component
void ShMemInput::startActivity()
{
    shmemSize_ = new ShMem(shMemSizeName_.toStdString().c_str(), sizeof(size_t));
    shmem_ = NULL;
}

//////////////////////////////////////////////////////////////////////////
/// Called by the ComponentManager to stop the component
void ShMemInput::stopActivity()
{
    //delete shmemSize_;
    //delete shmem_;
}

//////////////////////////////////////////////////////////////////////////
/// Called by the ComponentManager to pass the XML parameters to the
/// component
ComponentBase::COMPONENT_CONFIGURATION ShMemInput::configureComponent(XmlComponentConfig config)
{
    if (param.getProperty("memoryName") != QString::null)
        shMemName_ = param.getProperty("memoryName");
//    if (param.getProperty("alascaPort") != QString::null)
//        port_ = param.getProperty("alascaPort").toInt();

        shMemSizeName_ = shMemName_ + "Size";

    return ComponentBase::CONFIGURED_OK;
}

void ShMemInput::send(const QByteArray& data)
{
    qDebug() << "t[10]= " << road_time();
    if(shmem_ == NULL) {
        shMemSize_ = data.size();
       shmem_ = new ShMem(shMemName_.toStdString().c_str(), shMemSize_);
       LOG_WARN("Shared Memory allocated");
    }

    if(data.size() != shMemSize_) {
        LOG_WARN("Shared Memory size incorect");
        return;
    }
              qDebug() << "t[11]= " << road_time();
    shmemSize_->write(&shMemSize_,sizeof(size_t));
    shmem_->write((void*)(data.data()),shMemSize_);      // copy 4


              qDebug() << "t[12]= " << road_time();

}
