/*********************************************************************
//  created:    2007/11/13 - 10:48
//  filename:   ShMemInput.h
//
//  author:     Gerald Dherbomez & Sergio Rodriguez
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Definition of the ShMemInput class 
*********************************************************************/

#ifndef SHMEM_INTERFACE_H
#define SHMEM_INTERFACE_H

#include "kernel/ComponentBase.h"
#include <QThread>


namespace pacpus {
    
class ShMem;


//class PacpusGenericEvent : QEvent
//{
//public:
//    PacpusGenericEvent(QEvent::Type type, char* data, size_t size):QEvent(type) {
//     _data = (char*)malloc(size);
//    memcpy(_data,data,size);
//    _size = size;}
//    virtual ~PacpusGenericEvent() { free(_data);}
//    char* _data;
//    size_t _size;

//};

class  ShMemInput
        : public QObject
        , public ComponentBase
{
    Q_OBJECT

public:
    ShMemInput(QString name);
    ~ShMemInput();

    virtual void stopActivity();
    virtual void startActivity();
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
    
    void send(char* data, size_t size);
    void send(const QByteArray& data);

    void setDataSize(size_t size) { shMemSize_ = size;}

protected:   

    void addInputOutput();

    ShMem * shmem_,*shmemSize_;
    QString shMemName_, shMemSizeName_;
    size_t shMemSize_;

};

class  ShMemOutput
        : public QThread
        , public ComponentBase
{
    Q_OBJECT

public:
    ShMemOutput(QString name);
    ~ShMemOutput();

    virtual void stopActivity(); /*!< to stop the processing thread */
    virtual void startActivity(); /*!< to start the processing thread */
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
    

protected:   

    void addInputOutput();

    void run();

    ShMem * shmem_,*shmemSize_;
    QString shMemName_, shMemSizeName_;
    size_t shMemSize_;
    int timeout_;

};

} // namespace pacpus

#endif // SHMEM_INTERFACE_H
