/**
@file
Purpose: Lidar Detection

@date created 2010-06-03 16:13
@author Julien Moras
@author Sergio Rodriguez
@version $Id: $
*/

#include "testComponent1.h"

#include "kernel/ComponentFactory.h"
#include "kernel/Log.h"

#include "kernel/ComponentManager.h"
#include "testComponent2.h"

#include <stdio.h>

#include <QColor>


using namespace pacpus;
using namespace std;

DECLARE_STATIC_LOGGER("pacpus.cityvip.test.testComponent1");

const char * TestComponent1::COMPONENT_TYPE = "TestComponent1";

/// Construct the factory
static ComponentFactory<TestComponent1> sFactory(TestComponent1::COMPONENT_TYPE);

TestComponent1::TestComponent1(QString name)
    : ComponentBase(name)
{

    output.insert(QString("image"),new OutputInterface<QImage,TestComponent1>(QString("image"),this));

    LOG_TRACE("constructor(" << name << ")");
}

TestComponent1::~TestComponent1()
{
    LOG_TRACE("destructor");

}

ComponentBase::COMPONENT_CONFIGURATION
TestComponent1::configureComponent(XmlComponentConfig /*config*/)
{
    LOG_TRACE(Q_FUNC_INFO);

    LOG_INFO("component '" << componentName << "' configured");
    return ComponentBase::CONFIGURED_OK;
}
    
void TestComponent1::startActivity()
{
    LOG_TRACE(Q_FUNC_INFO);

    //Q_ASSERT(input);

    start();
    THREAD_ALIVE = true;
    setState(MONITOR_OK);
    LOG_INFO("started component '" << componentName << "'");
}

void TestComponent1::stopActivity()
{
    LOG_TRACE(Q_FUNC_INFO);

    THREAD_ALIVE = false;

    setState(STOPPED);
    LOG_INFO("stopped component '" << componentName << "'");
}

void TestComponent1::run()
{

OutputInterface<QImage,TestComponent1> * out1 = dynamic_cast<OutputInterface<QImage,TestComponent1> *> (output.value(QString("image")));

unsigned int i=0;
int waitTime =5000;
FILE *fp = fopen("test1.txt","w+");

QImage mat(10000,1000,QImage::Format_RGB32);
//mat.fill( qRgb(189, 149, 39));

    while(THREAD_ALIVE)
    {
        //mat.setPixel(0,0,i);
        LOG_INFO("Size " << mat.size().width()<< " x " << mat.size().height());
        out1->send(mat);

        LOG_INFO("Send data " << i << " time " << get_timestamp());
        fprintf(fp,"%u %lld \n",i, get_timestamp());
        usleep(waitTime);
        i++;
        setState(MONITOR_OK);
    }
        fclose(fp);

}
