/**
@file
Purpose: Lidar Detection

@date created 2010-06-03 16:13
@author Julien Moras
@author Sergio Rodriguez
@version $Id: $
*/

#ifndef TestComponent1_H
#define TestComponent1_H

#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/inputOutputInterface.h>

#include <QThread>
#include <QImage>

#include <Pacpus/kernel/road_time.h>
#include <Pacpus/PacpusTools/pacpusStruct.h>
#include "Pacpus/structure/genericStructures.h"

namespace pacpus {

typedef unsigned long long timestamp_t;

static timestamp_t get_timestamp ()
{
  struct timeval now;
  gettimeofday (&now, NULL);
  return  now.tv_usec + (timestamp_t)now.tv_sec * 1000000;
}

//class PacpusImage : public PacpusTimeStampedData {
//public :
//    QImage image;
//};


class TestComponent2;

class TestComponent1
        : public QThread
        , public ComponentBase
{
    Q_OBJECT

public:
    static const char * COMPONENT_TYPE;

    TestComponent1(QString name);
    ~TestComponent1();

    virtual void stopActivity();
    virtual void startActivity();
    virtual COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

protected:

    void run();


public Q_SLOTS:


private:
    //QThread thread;


};

} // namespace pacpus

#endif // TestComponent1_H
