/// Purpose: Inherits from the CanDriver class
///          Reimplement all the virtual members of the CanDriverBase 
///          class in order to be used with the Vector driver.  
///
/// @date created 2015/06/23
/// @author Gerald Dherbomez
/// @version $Id$

#ifndef __KVASERCANDRIVER_H__
#define __KVASERCANDRIVER_H__

#include <string>

#include "CanDriverBase.h"
#include "../CanGatewayConfig.h"

class CANGATEWAY_API KVaserCanDriver
    : public CanDriverBase
{
public:
  KVaserCanDriver(void);
  KVaserCanDriver(const int hwType, const int hwChannel, const unsigned long bitrate);
  KVaserCanDriver(const int channel);
  KVaserCanDriver(const int channel, const unsigned int bitRate);
  KVaserCanDriver(char * /*dummy1*/, char * /*dummy2*/) {} // DON'T USE
  ~KVaserCanDriver(void);

  void initialize(const int hwType, const int hwChannel, const unsigned long bitrate);

  short initPort (void);
  short cleanUpPort (void);

  void displayHardware(void);

  short sendFrame (struct CanFrame frame);
  short receiveFrame (struct CanFrame &frame);
  void waitReceivingFrame(void);

protected:
	
private:
	/*
  VportHandle		gPortHandle;		//!< Handle to the AC2PCI CAN Card 
  Vaccess			  gChannelMask;		//!< Mask to select the channel of the card (channel 0 or 1) 
  Vaccess			  gPermissionMask;	//!< Mask of the channel selected 
  unsigned int	gCanId;				//!< Identificator of the CAN frame send by the card 
  unsigned int	gBitRate;			//!< Variable which defined the bitrate of the card 
  unsigned int	gHwType;			//!< Defined the type of the hardware use for CAN communication. for the moment the only possible value is HWTYPE_CANAC2PCI for the AC2PCI CAN Card 
  int				    gHwChannel;			//!< Defined the channel of the card what we want used (channel 0 or 1) 
  HANDLE			  gEventHandle;		//!< Handle on a windows event for known if a CAN frame is present on the frame's buffer of the card 

  		XLaccess accessMask;
		XLportHandle port;
		XLhandle msgEvent;
*/

	int canHandle_;		//!< handle used to manage the CAN interface
	int canChannel_; 	//!< channel provided by the user
	int canBitRate_;	//!< frequency of the CAN bus (unit: bit/s)
	int kvaserHardwareType_;	//!< an ID specifying the hardware type, not used for the moment


};

#endif // XLVECTORCANDRIVER_H
