// *********************************************************************
//
//  created:    2015/09/18
//  filename:   ComponentTemplate.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc (c) UMR UTC/CNRS 7253
// 
//  license:    CECILL-C
// 
//  version:    $Id: $
//
//  brief:      Pacpus template component header file
//
// *********************************************************************


#ifndef __ComponentTemplate_h__
#define __ComponentTemplate_h__

#include "PluginTemplateConfig.h"

#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/InputOutputInterface.h>
#include <Pacpus/kernel/DbiteFile.h>

namespace pacpus 
{

  class PLUGINTEMPLATE_API ComponentTemplate
  : public QObject
  , public ComponentBase
  {
    Q_OBJECT

  public:
    // Specific constructor for pacpus component
    ComponentTemplate(QString name); 
    ~ComponentTemplate();

    // 3 inherited virtual pure methods
    virtual void startActivity();
    virtual void stopActivity();
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config); 

    virtual void addInputs();
    virtual void addOutputs();

    // void produceOutput();
    // void processInput(const int& value);


  private:
    // Add here your private variables
    unsigned long var_; 
    unsigned long parameter_;

    // Declaration of an output
    // OutputInterface<int, ComponentTemplate>* out1_;

  }; // end class ComponentTemplate

} // end namespace pacpus

#endif 