// *********************************************************************
//
//  created:    2015/09/18
//  filename:   MessageComponent.cpp
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc (c) UMR UTC/CNRS 7253
// 
//  license:    CECILL-C
// 
//  version:    $Id: $
//
//  brief:      Pacpus template component source file 
//
// *********************************************************************

#include "Pacpus/kernel/ComponentFactory.h"
#include "Pacpus/kernel/DbiteFileTypes.h"

#include "MessageComponent.h"

using namespace pacpus;


////////////////////////////////////////////////////////////////////////////////
/// Construct the factory
ComponentFactory<MessageComponent> sFactory("MessageComponent");



/************************************************************************/
/* Constructor
/************************************************************************/
MessageComponent::MessageComponent(QString name)
  : ComponentBase(name)
{
  count_ = 0;
}


/************************************************************************/
/* Destructor
/************************************************************************/
MessageComponent::~MessageComponent()
{  

}


/************************************************************************/
/* Start function, called by the ComponentManager when a start() 
/* command is received
/************************************************************************/
void MessageComponent::startActivity()
{
  // if you add an ouput, uncomment the line
  // out1_ = getTypedOutput<int, MessageComponent>("value");

  count_ = 0;
  connect(&timer_, SIGNAL(timeout()), this, SLOT(display()));
  timer_.start(period_ * 1000); // start a timer, param in msec

}


/************************************************************************/
/* Stop function, called by the ComponentManager when a stop() 
/* command is received
/************************************************************************/
void MessageComponent::stopActivity()
{
  timer_.stop();
}


/************************************************************************/
/* Called by the framework at initialization
/************************************************************************/
void MessageComponent::addInputs()
{
  // uncomment to add an input
  // addInput<int, MessageComponent>("value", &MessageComponent::processInput);
}


/************************************************************************/
/* Called by the framework at initialization
/************************************************************************/
void MessageComponent::addOutputs()
{
  // empty: no output
  // addOutput<int, ProducerExample>("value");
}


/************************************************************************/
/* Slot
/************************************************************************/
void MessageComponent::display()
{
  LOG_INFO(count_ << ": message from component " << name());
  count++
}


/************************************************************************/
/* Example function that produces an output
/************************************************************************/
// void MessageComponent::produceOutput()
// {
//   int val = 12;
//   checkedSend(out1_, val);
// }


/************************************************************************/
/* Example function that processes an input
/************************************************************************/
// void processInput(const int& value)
// {
//    
// }


/************************************************************************/
/* Configuration of the component, called by the ComponentManager after 
/* the construction of the object
/************************************************************************/
ComponentBase::COMPONENT_CONFIGURATION MessageComponent::configureComponent(XmlComponentConfig config)
{
  period_ = config.getDoubleProperty("msg_period"); 

	return ComponentBase::CONFIGURED_OK;
}

