/// @date created 2015/06/23
/// @author Gerald Dherbomez
/// @version $Id$

#include "KVaserCanDriver.h"
#include "kvaser/canlib.h"

#include <cassert>
#include <cstdio>
#include <iomanip>
#include <iostream>
#include <string>

#include "Pacpus/kernel/Log.h"
#include "../CanFrame.h"

using namespace pacpus;
using namespace std;

DECLARE_STATIC_LOGGER("pacpussensors.CanGateway.KVaserCanDriver");

#define WAIT_RECEIVING_FRAME_TIMEOUT 1000

/*
#define RX_QUEUE_SIZE 4096
#define QUEUE_LEVEL 1

bool checkXlStatus(const XLstatus status) {
	if ( status != XL_SUCCESS ) {
		XLstringType error = xlGetErrorString(status);
		LOG_ERROR(error);
		return false;
	} else {
		return true;
	}

}
*/
//
// Check a status code and issue an error message if the code isn't canOK.
//
void ErrorExit(char* id, canStatus stat)
{
    char buf[50];
    if (stat != canOK) {
        buf[0] = '\0';
        canGetErrorText(stat, buf, sizeof(buf));
        LOG_ERROR("%s: failed, stat=%d (%s)\n", id, (int)stat, buf);
        //exit(1);
    }
}

/**
* Constructor which enables to initialize the different attributes of the class with default values.
* @see ~KVaserCanDriver (void)
*/

KVaserCanDriver::KVaserCanDriver(int channel, unsigned int bitRate)
{
  LOG_INFO("Notice : KVASER CAN Driver used\n");
  canChannel_ = channel;
  canBitRate_ = bitRate;
  kvaserHardwareType_ = 0;
}


/**
* Constructor which enables to initialize the different attributes of the class with default values.
* @see ~KVaserCanDriver (void)
* @see KVaserCanDriver (unsigned int gHwTypeT, Vaccess gChannelMaskT, unsigned int gCanIdT, unsigned int gBitRateT,int gHwChannelT)
*/

KVaserCanDriver::KVaserCanDriver (void)
{
  LOG_INFO("Notice : KVASER CAN Driver used\n");
  canChannel_ = 0;
  canBitRate_ = 500000;
  kvaserHardwareType_ = 0;
}

/**
* Constructor which enables to initialize the different attributes of the class with values given in parameters.
* @see ~KVaserCanDriver (void)
* @see KVaserCanDriver (void)
*/
KVaserCanDriver::KVaserCanDriver(const int hwType, const int hwChannel, const unsigned long bitrate)
{
  canChannel_ = hwChannel;
  canBitRate_ = bitrate;
  kvaserHardwareType_ = hwType;
}


/**
* Constructor which enables to select the channel and to initialize the different attributes of the class with default values..
* @see ~KVaserCanDriver (void)
* @see KVaserCanDriver (void)
*/

KVaserCanDriver::KVaserCanDriver(int channel)
{
  LOG_INFO("Notice : KVASER CAN Driver used\n");
  canChannel_ = channel;
  canBitRate_ = 500000;
  kvaserHardwareType_ = 0;
}



/**
* Destructor which clean up the different attributs of the class.
* @see KVaserCanDriver (void)
*/
KVaserCanDriver::~KVaserCanDriver (void)
{

}



void KVaserCanDriver::displayHardware() 
{
	LOG_INFO("----------------------------------------------------------");
	LOG_INFO("KVASER DRIVER HARDWARE INFORMATION -- TODO");
	LOG_INFO("KVASER DRIVER VERSION: 5_11_931 ");
	LOG_INFO("----------------------------------------------------------");
}


void KVaserCanDriver::initialize(const int hwType, const int hwChannel, const unsigned long bitrate)
{
  LOG_INFO("Notice : KVASER CAN Driver used\n");
  displayHardware();

  canHandle_ = canOpenChannel(hwChannel, 0);
    if (canHandle_ < 0) {
        ErrorExit("canOpenChannel", (canStatus)canHandle_);
    }
	else 
	{
		int ret = 0;
		switch (bitrate)
		{
			case 125000:
				ret = canSetBusParams(canHandle_, canBITRATE_125K, 0, 0, 0, 0, 0);
				break;
			case 250000:
				ret = canSetBusParams(canHandle_, canBITRATE_250K, 0, 0, 0, 0, 0);
				break;
			case 500000:
				ret = canSetBusParams(canHandle_, canBITRATE_500K, 0, 0, 0, 0, 0);
				break;
			default:
				ret = canERR_NOTFOUND;
				break;
		}
		if (ret < 0) {
			ErrorExit("canSetBusParams", (canStatus)ret);
		}

		ret = canBusOn(canHandle_);
		if (ret < 0) {
			ErrorExit("canBusOn", (canStatus)ret);
        
		}
	}
}


/**
* Member used to initialise the configuration of the CAN Card.
* @see cleanUpPort (void)
* @return a Vstatus variable which contain the error code of the function. On success, it return VSUCCESS. On failure, it return Vstatus error code which is defined in VCanD.h
*/
short KVaserCanDriver::initPort (void)
{
	//
    // Initialize CANLIB.
    //
    canInitializeLibrary();

	// open the physical CAN interface
	initialize(kvaserHardwareType_, canChannel_, canBitRate_);

	return 0;
}


/**
* Member used to clean up the configuration of the CAN Card.
* @see initPort (void)
* @return a Vstatus variable which contain the error code of the function. On success, it return VSUCCESS. On failure, it return Vstatus error code which is defined in VCanD.h
*/
short KVaserCanDriver::cleanUpPort (void)
{
	
	//traceXLCommand("xlCloseDriver", xlCloseDriver());

	canBusOff(canHandle_);
	canClose(canHandle_);

	return 0;
}


/**
* Member which permit to send a frame on the CAN bus and test if the frame is well acknowledged.
*/
short KVaserCanDriver::sendFrame (struct CanFrame frame)
{
	canStatus stat = canWrite(canHandle_, frame.id,frame.data, frame.dlc, 0);
	if (stat == canOK ) 
	{
		return 0;
	} else {
		LOG_WARN("Kvaser driver - sendFrame method - Failed to send the CAN frame");
		return 1; 
	}
}


/**
* Member which permit to receive of a frame on the CAN bus.
*/
//Vstatus KVaserCanDriver::receiveFrame (unsigned char * flags, unsigned char * dlc, unsigned char * data, int * identifiant)
short KVaserCanDriver::receiveFrame (struct CanFrame &frame)
{
	long id;
	unsigned int dlc, flags;
	unsigned char msg[8];
	DWORD time;
	
	canStatus stat = canReadWait(canHandle_, &id, msg, &dlc, &flags, &time, WAIT_RECEIVING_FRAME_TIMEOUT);
	if (stat == canOK ) 
	{
		if ((flags & canMSG_ERROR_FRAME) == 0) 
		{
			// Get the message data
			/*fprintf(f, "%8lu%c%c%c%c  %02lu ",
				id,
				flags & canMSG_EXT        ? 'x' : ' ',
				flags & canMSG_RTR        ? 'R' : ' ',
				flags & canMSGERR_OVERRUN ? 'o' : ' ',
				flags & canMSG_NERR       ? 'N' : ' ', // TJA 1053/1054 transceivers only
				dlc);*/
			frame.id = id;
			frame.dlc = dlc;
			memcpy(frame.data, msg, frame.dlc);
			return 0;
		} 
	} 
	else if (stat == canERR_NOMSG ) {
			// timeout occurs
			LOG_WARN("Kvaser card - receiveFrame() method - TIMEOUT");
			return 1;
	} 
	else {
			// An error frame.
			LOG_WARN("Kvaser card, error frame");
			return 1;
	}


	return 1;
}


/**
* Member which wait the reception of a frame on the CAN bus.
* @see sendFrame (unsigned char flags, unsigned char dlc, unsigned char * data)
* @see receiveFrame (unsigned char * flags, unsigned char * dlc, unsigned char ** data)
*/
void KVaserCanDriver::waitReceivingFrame(void)
{
	LOG_WARN("KVASER driver - waitReceivingFrame(void) method - Not yet implemented");
}
