/**
@file
Purpose: Lidar Detection

@date created 2010-06-03 16:13
@author Julien Moras
@author Sergio Rodriguez
@version $Id: $
*/

#include "testComponent2.h"

#include "kernel/ComponentFactory.h"
#include "kernel/Log.h"

#include "testComponent1.h"

using namespace pacpus;
using namespace std;

DECLARE_STATIC_LOGGER("pacpus.cityvip.test.TestComponent2");

const char * TestComponent2::COMPONENT_TYPE = "TestComponent2";

/// Construct the factory
static ComponentFactory<TestComponent2> sFactory(TestComponent2::COMPONENT_TYPE);

TestComponent2::TestComponent2(QString name)
    : ComponentBase(name)
{
    LOG_TRACE("constructor(" << name << ")");

    addInputOutput();
    moveToThread(&thread);
    LOG_INFO("Thread " << thread.currentThread());
    LOG_INFO("Current Thread " << QThread::currentThread());
}

TestComponent2::~TestComponent2()
{
    LOG_TRACE("destructor");

}

void TestComponent2::addInputOutput()
{
    input.insert("image",new InputInterface<QImage,TestComponent2> ("image",this,&TestComponent2::process2));
}

ComponentBase::COMPONENT_CONFIGURATION
TestComponent2::configureComponent(XmlComponentConfig /*config*/)
{
    LOG_TRACE(Q_FUNC_INFO);

    // load XML parameters

    LOG_INFO("component '" << componentName << "' configured");
    return ComponentBase::CONFIGURED_OK;
}
    
void TestComponent2::startActivity()
{
    LOG_TRACE(Q_FUNC_INFO);

    //Q_ASSERT(input);
    fp = fopen("test2.txt","w+");
    i=0;
    thread.start();
    THREAD_ALIVE = true;

    setState(MONITOR_OK);
    LOG_INFO("started component '" << componentName << "'");
}

void TestComponent2::stopActivity()
{
    LOG_TRACE(Q_FUNC_INFO);

    THREAD_ALIVE = false;
    thread.quit();
        fclose(fp);
    setState(STOPPED);
    LOG_INFO("stopped component '" << componentName << "'");
}

void TestComponent2::process2(const QImage& matrix)
{
    LOG_INFO("Size " << matrix.size().width()<< " x " << matrix.size().height());
    //QImage matrix = a.value<QImage>();
    unsigned int k;

//    for(int i=0;i<100;i++){
//        for(int j=0;j<100;j++){
//        //k=matrix.pixel(0,0);
//        }
//    }
//        fprintf(fp,"%u %lld \n",i++, get_timestamp());

    setState(MONITOR_OK);
    LOG_INFO("Processed " << k << " time " << get_timestamp());
}
