#ifndef IN_OUT_INTERFACE_H
#define IN_OUT_INTERFACE_H

#include <Pacpus/kernel/pacpus.h>
#include <Pacpus/kernel/inputOutputBase.h>
#include <Pacpus/kernel/Log.h>
#include <Pacpus/kernel/PacpusEvent.h>
#include <Pacpus/kernel/CommunicationComponent.h>

#include <typeinfo>
#include <QThread>
#include <QDebug>
#include <QApplication>

#include <QByteArray>

#define ADD_INPUT(name,ComponentType, DataType, functionName)  input.insert(name,new InputInterface<DataType,ComponentType> (name,this,&ComponentType::functionName))
#define ADD_OUTPUT(name,ComponentType, DataType)      output.insert(name,new OutputInterface<DataType,ComponentType> (name,this))
#define GET_OUTPUT(name,ComponentType, DataType) dynamic_cast<OutputInterface<DataType,ComponentType> *> (output.value(name))

namespace pacpus {

template <class T, class C>
class InputInterface : public InputInterfaceBase
{
public:
    InputInterface(QString name, C * component, void (C::*m)(const T&)):InputInterfaceBase(name,component,component), method(m) {}
    ~InputInterface() {}

    enum ReadingMode {
        NeverSkip,
        TimeBounded,
        GetLast
    };

    void setReadingMode(ReadingMode mode) { readingMode_ = mode;}
    size_t getDataSize() {return sizeof(T);}
    QString getDataType() {return QString(typeid(T).name());}

    protected:
    ReadingMode readingMode_;
    int boundingTime_;

    public:

    void customEvent(QEvent* event) {

        switch (event->type()) {

                // from Component to Component (T->T)
            case TYPED_EVENT: {
                PacpusTypedEvent<T> * typedEvent = dynamic_cast<PacpusTypedEvent<T> *> (event);
                //qDebug() << "E1 ";
                //qDebug() << "recived 2 thread " << QThread::currentThread();
                    if(typedEvent->tr_ == 0 && readingMode_ == TimeBounded) {
                        //LOG_WARN("Incorrect TimeRange (0), switch to NeverSkip");
                        readingMode_ = NeverSkip;}

                switch (readingMode_){
                    case TimeBounded:
                    if(road_time() - typedEvent->t_> typedEvent->tr_)
                        break;
                        (dynamic_cast<C*>(_component)->*method)(typedEvent->_data);
                        break;
                    case GetLast:
                        (dynamic_cast<C*>(_component)->*method)(typedEvent->_data);
                        QCoreApplication::removePostedEvents(this,TYPED_EVENT); // delete all remining events
                        break;
                    case NeverSkip:
                    default:
                        (dynamic_cast<C*>(_component)->*method)(typedEvent->_data);
                }
                break;
            }

                // from Connection interface to Component (G->T)
            case GENERIC_EVENT2: {
                PacpusTypedEvent<QByteArray> * genericEvent = dynamic_cast<PacpusTypedEvent<QByteArray> *> (event);
                qDebug() << "E2 ";
                //if(sizeof(T) != genericEvent->_data.size())
                //    qDebug() << "Incorrecte size " << sizeof(T) << " " << genericEvent->_data.size();
              qDebug() << "t[18]= " << road_time();
                T data;
                QByteArray& buf = (QByteArray&) genericEvent->_data;
                //qDebug() << "DataSize " <<buf.size();
                QDataStream in(&buf,QIODevice::ReadOnly);

                qDebug() << "t[19]= " << road_time();
                //in >> data; // copy 7
                qDebug() << "t[20]= " << road_time();

                (dynamic_cast<C*>(_component)->*method)(data); // copy 8 X

                qDebug() << "t[21]= " << road_time();
                break;
            }

                // from Component to Connection interface (T->G) (Typed in QByteArray)
            case GENERIC_EVENT3: {
                PacpusTypedEvent<T> * typedEvent = dynamic_cast<PacpusTypedEvent<T> *> (event);
                qDebug() << "E3 ";
              qDebug() << "t[6]= " << road_time();
                (dynamic_cast<C*>(_component)->*method)(typedEvent->_data);     // copy 3 X
              qDebug() << "t[7]= " << road_time();
                break;
            }

            default:

            qDebug() << "Bad event ID " << event->type();
                break;
        }


    }

protected:
    void (C::*method)(const T&);

};

template <class T, class C>
class OutputInterface : public OutputInterfaceBase
{
public:
    OutputInterface(QString name, C * component):OutputInterfaceBase(name,component,component) {}
    ~OutputInterface() {}

    // Used by Components to send data througth typed output
    void send(const T & data) {
        for(QList<ConnectionBase>::iterator it = _connection.begin(); it!=_connection.end(); ++it){

            if(it->getInputInterface()->getDataType() != QString(typeid(QByteArray).name()))
                QApplication::postEvent(it->getInputInterface(),new PacpusTypedEvent<T>(QEvent::Type(TYPED_EVENT),data),it->getPriority());
           else {
              qDebug() << "t[1]= " << road_time();
                //QByteArray buf((char*)(&data),sizeof(T));
                QByteArray buf;
                QDataStream out(&buf,QIODevice::ReadWrite);
              qDebug() << "t[2]= " << road_time();
               // out << data;    // Copy 1
              qDebug() << "t[3]= " << road_time();

                PacpusTypedEvent<QByteArray> * ev =new PacpusTypedEvent<QByteArray>(QEvent::Type(GENERIC_EVENT3),buf);
              qDebug() << "t[4]= " << road_time();
                QApplication::postEvent(it->getInputInterface(),ev,it->getPriority()); // Copy 2 (ctor)
              qDebug() << "t[5]= " << road_time();
                //QApplication::postEvent(it->getInputInterface(),new PacpusTypedEvent<QByteArray>(QEvent::Type(GENERIC_EVENT3),buf),it->getPriority()); // Copy 2 (ctor)
                }

        //qDebug() << "send thread " << QThread::currentThread();
        }
    }

    // Used by Connection Interfaces only to pose generic event
    void sendGenericData(char * data, size_t size) {
              qDebug() << "t[15]= " << road_time();
        QByteArray buf(data,size);  // copy 5
              qDebug() << "t[16]= " << road_time();
        for(QList<ConnectionBase>::iterator it = _connection.begin(); it!=_connection.end(); ++it)
            QApplication::postEvent(it->getInputInterface(),new PacpusTypedEvent<QByteArray>(QEvent::Type(GENERIC_EVENT2),buf),it->getPriority()); // Copy 6(ctor)
              qDebug() << "t[17]= " << road_time();
        //qDebug() << "send thread " << QThread::currentThread();
    }

    size_t getDataSize() {return sizeof(T);}
    QString getDataType() {return QString(typeid(T).name());}
};


} // namespace pacpus

#endif // IN_OUT_INTERFACE_H
