#ifndef ConnectionBase_H
#define ConnectionBase_H


namespace pacpus {

class AbstractInterface;

class ConnectionBase
{
public:
    ConnectionBase(AbstractInterface * interface, int priority):_interface(interface),_priority(priority) {}
    ~ConnectionBase() {}

    AbstractInterface *  getInterface() const {return _interface;}
    int getPriority() const {return _priority;}

    bool operator== (ConnectionBase const &c) {
        return _interface == c.getInterface() && _priority == c.getPriority();}

private:
    AbstractInterface * _interface;
    int _priority;
};

} // namespace pacpus

#endif // ConnectionBase_H
