#ifndef PACPUS_EVENT_H
#define PACPUS_EVENT_H

#include <QEvent>
#include "Pacpus/kernel/road_time.h"
#include <Pacpus/kernel/pacpus.h>
#include <QDataStream>

namespace pacpus {

class GenericData {
public:
    GenericData(char* data, size_t size) {
        _data = (char*)malloc(size);
        memcpy(_data,data,size);
        _size = size;}

    ~GenericData() {free(_data);}

    char * data() { return _data;}
    size_t size() {return _size;}

private:
char* _data;
size_t _size;
};

enum PacpusEventType  {
    TYPED_EVENT = 1000,
    GENERIC_EVENT = 2000,
    GENERIC_EVENT2 = 2002,
    GENERIC_EVENT3 = 2003,
    CONFIG_EVENT = 3000
};

class PACPUSLIB_API PacpusEvent : public QEvent
{
public:
    PacpusEvent(PacpusEventType type, road_time_t t = road_time(), road_timerange_t tr = 0):QEvent(QEvent::Type(type)),t_(t),tr_(tr) {}
    virtual ~PacpusEvent() {}

    virtual QDataStream& streamOut(QDataStream& out) {}; // NOTE virtual pure ??
    virtual QDataStream& streamIn(QDataStream& in) {};

public: // TODO make protected
    road_time_t t_;
    road_timerange_t tr_;
};

template<class T>
class PacpusTypedEvent : public PacpusEvent
{
public:
    PacpusTypedEvent(PacpusEventType type, T data = T(), road_time_t t = road_time(), road_timerange_t tr = 0 ):PacpusEvent(type, t, tr),_data(data) {}
    ~PacpusTypedEvent() {}

    QDataStream& streamOut(QDataStream& out) {return out << (quint64)t_ << tr_ /*<<_data*/;} // FIXME Stream Data errors
    QDataStream& streamIn(QDataStream& in) {return in >> (quint64&)t_ >> tr_ /*>> _data*/;}

public: // TODO make protected
    T _data;
};

inline QDataStream& operator << (QDataStream& out, PacpusEvent& ev) {return ev.streamOut(out);}
inline QDataStream& operator >> (QDataStream& in, PacpusEvent& ev) {return ev.streamIn(in);}

class PACPUSLIB_API PacpusGenericEvent : public PacpusEvent
{
public:
    PacpusGenericEvent(PacpusEventType type, char* data, size_t size):PacpusEvent(type) {
        _data = (char*)malloc(size);
        memcpy(_data,data,size);
        _size = size;

    }
    virtual ~PacpusGenericEvent() {free(_data);}
    char* _data;
    size_t _size;
};


} // namespace pacpus

#endif // PACPUS_EVENT_H
