#ifndef __POLARXMAINWINDOW__
#define __POLARXMAINWINDOW__

//#include <QtGui>
#include <QtWidgets>
#include <bitset>
#include "../structure_gps.h"
#include "../SeptentrioSocket.h"
#include "PacpusTools/BinaryDecoder.h"

class PolarxMainWindow : public QWidget
{
   Q_OBJECT

   public :
      PolarxMainWindow() ;
      ~PolarxMainWindow() {} ;

      void setData( unsigned char * data , int buf_size ) ;
      /*void setReceiverStatus( SbfDataReceiverStatus * msg ) ;
      void setTrackingStatus( SbfDataTrackingStatus * msg ) ;
      void setPVTGeodetic( SbfDataPVTGeodetic * msg ) ;*/
      void setSocket( SeptentrioSocket * socket ) ;

   protected slots :


   private :
      int ipID ;
      int elevMask_set ;
      std::vector<unsigned char> buffer ;
      QLabel * TOW ;
      QLabel * WNC ;
      QLabel * RXLOAD ;
      QLabel * UPTIME ;
      QLabel * CHAN_USED ;
      QLabel * PVT_USED ;
      QLabel * PVT_lat ;
      QLabel * PVT_lon ;
      QLabel * PVT_elv ;
      QLabel * SYSTEM ;
      QLabel * SYSTEM2 ;
      QLabel * SYSTEM3 ;
      QLabel * MODE ;
      QStandardItemModel * TRACKINGSTATUS ;
      SeptentrioSocket * socketIf_ ;
      QStringList avFrame ;
      QPushButton * upFrame ;
      QPushButton * upSetup ;

      QMap< QString , QCheckBox * > sbfBlock_disp ;
      QMap< QString , QCheckBox * > pvtMode ;
      QComboBox * pvtInterval ;
      QComboBox * measInterval ;
      QComboBox * trkMode ;
      QSpinBox * elevMask ;
      QString pvtInt_set ;
      QString measInt_set ;
      QString trkMode_set ;

      void pvtError( QString err );
      void getAvailableFrame( QString cmd );
      void getPvtInterval( QString cmd );
      void requestFrame();
      void initSbfBlock(QWidget * parent);
      void initStatusBlock( QWidget * parent ) ;
      void initSetupBlock( QWidget * parent ) ;
      void commandManager( QStringList cmdList );
      void extractIpID( QString cmd ) ;
      void getPvtMode( QString cmd ) ;
      void getElevationMask( QString cmd ) ;
      void getMeasInterval( QString cmd ) ;
      void getTrackingMode( QString cmd ) ;

   private slots :
      void sendNewFrame() ;
      void sendNewSetup() ;

};


#endif
