/*********************************************************************
//  created:    2012/03/01 - 14:06
//  filename:   PS3remote.h
//
//  author:     Pierre Hudelaine
//              Copyright Heudiasyc UMR UTC/CNRS 7253
//
//  version:    $Id: $
//
//  purpose:    Read the dualshock 3 buttons using bluetooth
//
*********************************************************************/

#ifndef PS3_REMOTE_H
# define PS3_REMOTE_H

# include <QApplication>
# include <QThread>
# include <QTimer>
# include <QMutex>

# include "../Dualshock/controller.h"
# include "../PacpusSocket/PacpusUDPSocket.h"

namespace pacpus {

  class PS3remote: public QThread {
        Q_OBJECT

        public:
	    PS3remote();
        PS3remote(PacpusUDPSocket *socket);
	    ~PS3remote();
	    void run();
	    void stop();
	    void setCmd(uint16_t Ls, uint16_t Rs, int leftF, int rightF);
	    void sendCmd();
	    void modePS3();
	    void modeChar();
	    void modeJoystick();
	    void checkMode();

        private:
	    ShMem *shmem;
	    struct dualshockButtons_s * b;
	    QMutex mutex;
	    int quit;
	    PacpusUDPSocket * socket_;
	    QTimer * timer_;
	    char buf[4];

	public Q_SLOTS:
	    void wifibotRemanentSending();
    };

};

#endif
