/*********************************************************************
//  created:    2012/03/01 - 14:06
//  filename:   dualshock.cpp
//
//  author:     Pierre Hudelaine
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    Read the dualshock 3 button using bluetooth
//
*********************************************************************/

#ifndef DUALSHOCK_H
# define DUALSHOCK_H

# include <kernel/ComponentBase.h>
# include <kernel/DbiteFile.h>
# include "controller.h"

#ifdef WIN32
# ifdef PACPUS_DUALSHOCK_API_EXPORTS
       define PACPUS_DUALSHOCK_API __declspec(dllexport)
# else
       define PACPUS_DUALSHOCK_API __declspec(dllimport)
# endif
# else
#  define PACPUS_DUALSHOCK_API
#endif

namespace pacpus {

    class PACPUS_DUALSHOCK_API Dualshock
        : public ComponentBase {
            public:
                Dualshock(QString name);
                ~Dualshock();

                virtual void stopActivity();
                virtual void startActivity();
                virtual ComponentBase::COMPONENT_CONFIGURATION
                    configureComponent(XmlComponentConfig config);

            private:
                pacpus::DbiteFile file_;
                DualshockAPI *d;

        };
}


#endif /* DUALSHOCK_H */
