/*********************************************************************
//  created:    2008/07/18 - 15:33
//  filename:   SeptentrioSocket.cpp
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 6599
//
//  version:    $Id: $
//
//  purpose:    Management of the TCP/IP connection with the Septentrio
//              receiver.
*********************************************************************/



#include "SeptentrioSocket.h"
//#include "SeptentrioComponent.h"
#include <QApplication>
#include <QtDebug>



//////////////////////////////////////////////////////////////////////////
// Constructor
//////////////////////////////////////////////////////////////////////////
SeptentrioSocket::SeptentrioSocket() : sem(MAX_RESOURCES_COUNT)
{
    sem.acquire(MAX_RESOURCES_COUNT);
    socket_ = new QTcpSocket(this);
    connect( socket_, SIGNAL(connected()), this,SLOT(socketConnected()) );
    connect( socket_, SIGNAL(disconnected()),this, SLOT(socketConnectionClosed()) );
    connect( socket_, SIGNAL(readyRead()),this, SLOT(socketReadyRead()) );
    connect( socket_, SIGNAL(error(QAbstractSocket::SocketError)), this, SLOT(socketError(QAbstractSocket::SocketError)) );
}



//////////////////////////////////////////////////////////////////////////
// Destructor
//////////////////////////////////////////////////////////////////////////
SeptentrioSocket::~SeptentrioSocket()
{
    delete socket_;
}




//////////////////////////////////////////////////////////////////////////
// public slot
// connection to server
//////////////////////////////////////////////////////////////////////////
void SeptentrioSocket::connectToServer(QString host, int port)
{
    qDebug("trying to connect to server");
    socket_->connectToHost(host,port);
}




//////////////////////////////////////////////////////////////////////////
// protected slot
//////////////////////////////////////////////////////////////////////////
int SeptentrioSocket::socketConnected()
{
    qDebug() << "we are connected to the server " << socket_->peerName().toLatin1()
    << " at the port " << socket_->peerPort() << " via the socket " << socket_->socketDescriptor();

    // request data as soon as we are connected
//   sendToServer("sso curr all\n");

    return 1;
}





//////////////////////////////////////////////////////////////////////////
// protected slot
//////////////////////////////////////////////////////////////////////////
void SeptentrioSocket::socketConnectionClosed()
{
    qDebug("the connection was closed");
}




//////////////////////////////////////////////////////////////////////////
// protected slot
// new incoming data to read
//////////////////////////////////////////////////////////////////////////
void SeptentrioSocket::socketReadyRead()
{
    SbfFrame frame;
    frame.time = road_time();
    if ( socket_->bytesAvailable() <= SBFBLOCK_MAX_LENGTH)
    {
        frame.size = socket_->bytesAvailable();
// 		printf("received = %d\n",frame.size);
    }
    else
    {
        qDebug() << "Problem with SeptentrioSocket: size of data exceeds maximal capacity of "<< SBFBLOCK_MAX_LENGTH << " bytes. \nData will be ignored !";
        socket_->readAll();
    }
    frame.size = socket_->read( (char*)&(frame.data), frame.size );
    sbfFrames.push(frame);
    sem.release();
}


//////////////////////////////////////////////////////////////////////////
// protected slot
//////////////////////////////////////////////////////////////////////////
void SeptentrioSocket::socketError( QAbstractSocket::SocketError e )
{
    qWarning("socket error number %d",e);
}



//////////////////////////////////////////////////////////////////////////
// Send data to server via a text stream
//////////////////////////////////////////////////////////////////////////
void SeptentrioSocket::sendToServer(QString data)
{
    mutex_.lock();
    QTextStream os(socket_);
    os << data << endl;
    mutex_.unlock();
    qDebug() << "data sent to server: " << data.toLatin1();
}
