#ifndef LADYBUGCOMPONENT_H
#define LADYBUGCOMPONENT_H

//#include "Pacpus/kernel/pacpus.h"
#include "Pacpus/kernel/ComponentBase.h"
//#include "Pacpus/kernel/DbiteFile.h"
//#include "../NMEA0183/include/nmea0183.h"

#include <QSemaphore>
#include <QThread>

#include "ladybug.h"
#include <ladybuggeom.h>
#include <ladybugrenderer.h>
#include <ladybugstream.h>
#include <ladybugGPS.h>

#include "opencv2\core\core.hpp"
#include "opencv2\imgproc\imgproc.hpp"
#include "opencv2\highgui\highgui.hpp"

//#include "Pacpus/PacpusTools/ShMem.h"

//#include "qstring.h"

// Export macro for PluginTest DLL for Windows only
#ifdef WIN32
#ifdef LADYBUG_EXPORTS
// make DLL
#define LADYBUG_API __declspec(dllexport)
#else
// use DLL
#       define LADYBUG_API __declspec(dllimport)
#endif
#else
// On other platforms, simply ignore this 
#   define LADYBUG_API /* nothing */
#endif

#define _DISPLAY_ERROR_MSG_AND_RETURN \
    if( error != LADYBUG_OK ) \
   { \
   printf( "Ladybug library reported %s\n", \
   ::ladybugErrorToString( error ) ); \
   return; \
   } \

#define PANORAMIC_IMAGE_WIDTH    2048
#define PANORAMIC_IMAGE_HEIGHT   1024 

namespace pacpus
{
	class LADYBUG_API LadybugComponent : public QThread, public ComponentBase
	{
		//Q_OBJECT

		public:
			//============================= DEFAULT ELEMENTS ===============================================
			LadybugComponent(QString name);
			~LadybugComponent();

			void StartCamera();
			void CreateImageBuffers();
			void run();
			void HandleError(LadybugError error);
			void SaveVideoStream(LadybugImage* image);
			void SaveJPGImages(LadybugImage* image);
			void SavePanoImage(LadybugImage* image);

			virtual void stopActivity(); /*!< to stop the processing thread */
			virtual void startActivity(); /*!< to start the processing thread */
			virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
			//==============================================================================================

			protected:
				//bool is_running; /* *Indicates that thread is running*/

			public:
				void InitDefault(); /* *Initialize default values*/


			private:
				bool THREAD_ALIVE;

				/* Cameras variables*/
				//LadybugError error;
				LadybugContext lbContext;
				LadybugCameraInfo lbCamInfo;
				LadybugStreamContext lbStreamContext;
				LadybugImage lbImageCurrent, lbImagePrev;

				LadybugTriggerModeInfo triggerModeInfo;
				LadybugTriggerMode triggerMode;

				unsigned char* lbArpBuffers[LADYBUG_NUM_CAMERAS];

				double lbFrameCount;
				double lbCurrentTime;
				double lbElapsedTime;
				double lbLastUpdateTime;


				/* Config variables*/
				//int lbDataFormat;
				//int lbColorProcessingMethod;
				//int lbDisplayType;
				int lbSavePanoImage;
				int lbSaveVideoStream;
				int lbSaveJPGImages;
				int lbTriggerOn;
				int lbTriggerMode;
				int lbTriggerSource;
				int lbTriggerParam;
				int lbTriggerPolarity;


				/* Control variables*/
				bool lbIsRecording;
				double lbTotalMBWritten;
				unsigned long lbTotalNumberOfImagesWritten;
				int lbNumOfFrames;

	};
}

#endif // LADYBUGCOMPONENT_H