/*********************************************************************
//  created:    2012/03/01 - 14:06
//  filename:   TelnetClient.cpp
//
//  author:     Pierre Hudelaine
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    Create network socket if needed in Pacpus
//
*********************************************************************/

#include "TelnetClient.h" 
#include <string>

using namespace pacpus;
using namespace std;

/// Default host address = 0.0.0.0 (any address)
static const string kDefaultHostAddress = "127.0.0.1";
/// Default host port = 2368
static const uint16_t kDefaultHostPort = 2368;

DECLARE_STATIC_LOGGER("pacpus.base.TelnetClient");


//////////////////////////////////////////////////////////////////////////
// Construct the factory
//////////////////////////////////////////////////////////////////////////
static ComponentFactory <TelnetClient> sFactory("TelnetClient");  


//////////////////////////////////////////////////////////////////////////
// Constructeur
//////////////////////////////////////////////////////////////////////////
TelnetClient::TelnetClient(QString name)
    : ComponentBase(name) 
{
    address_.setAddress(kDefaultHostAddress.c_str());
    port_ = kDefaultHostPort;
} 


//////////////////////////////////////////////////////////////////////////
// Destructor
//////////////////////////////////////////////////////////////////////////
TelnetClient::~TelnetClient() 
{
}


//////////////////////////////////////////////////////////////////////////
// Called by the ComponentManager to pass the XML parameters to the 
// component 
//////////////////////////////////////////////////////////////////////////
ComponentBase::COMPONENT_CONFIGURATION  TelnetClient::configureComponent(XmlComponentConfig config) 
{ 

	return ComponentBase::CONFIGURED_OK; 
} 


//////////////////////////////////////////////////////////////////////////
// Called by the ComponentManager to start the component
//////////////////////////////////////////////////////////////////////////
void TelnetClient::startActivity() 
{ 
	if (!(socket_ = new QTcpSocket()))
		qFatal("Failed to init socket!");

	connect(socket_, SIGNAL(connected()), this, SLOT(ConnectionMessage()));
  
	socket_->connectToHost(address_, port_, QIODevice::ReadWrite); 

	connect(socket_, SIGNAL(readyRead()), this, SLOT(readPendingDatagrams()));
}

void TelnetClient::ConnectionMessage()
{
	qDebug() << "Connected to the server"; 
}

/*
void TelnetClient::sendDatagrams(QString frame) 
{ 
	int sent=0;
	
	if (socketType_ == "client")
	{
	    if ((sent = socket_->writeDatagram(frame.toLocal8Bit(), address2send_, port2send_)) == -1) 
			qDebug() << "Failed to send the frame: " << address2send_ << port2send_ << frame << endl; 
	    //else 
			//qDebug() << "TO NETWORK:" << address2send_ << port2send_ << frame << "size" << sent;
	}
	else if (socketType_ == "server")
	{
	    for (int i = 0; i < listClients.size(); i++)
	    {
			if ((sent = socket_->writeDatagram(frame.toLocal8Bit(), listClients[i]->getAddress(), listClients[i]->getPort())) == -1) 
				qDebug() << "Failed to send the frame: " << listClients[i]->getAddress() << listClients[i]->getPort() << frame << endl; 
			//else 
				//qDebug() << "TO NETWORK:" << listClients[i]->getAddress() << listClients[i]->getPort() << frame << "size" << sent;  	
	    }
	}
} 


void TelnetClient::sendDatagrams(QByteArray frame) 
{ 
	int sent=0;
	
	if (socketType_ == "client")
	{
	    if ((sent = socket_->writeDatagram(frame, address2send_, port2send_)) == -1) 
			qDebug() << "Failed to send the frame: " << address2send_ << port2send_ << frame << endl; 
	    //else 
			//qDebug() << "TO NETWORK:" << address2send_ << port2send_ << frame << "size" << sent;
	}
	else if (socketType_ == "server")
	{
	    for (int i = 0; i < listClients.size(); i++)
	    {
			if ((sent = socket_->writeDatagram(frame, listClients[i]->getAddress(), listClients[i]->getPort())) == -1) 
				qDebug() << "Failed to send the frame: " << listClients[i]->getAddress() << listClients[i]->getPort() << frame << endl; 
			//else 
				//qDebug() << "TO NETWORK:" << listClients[i]->getAddress() << listClients[i]->getPort() << frame << "size" << sent;  	
	    }
	}
} 
*/

void TelnetClient::readPendingDatagrams()
{
	/*
	while (socket_->hasPendingDatagrams())  
	{
		QByteArray datagram; 
		datagram.resize(socket_->pendingDatagramSize()); 
		QHostAddress sender; 
		quint16 senderPort;
    
	}*/

		
	QDataStream in(socket_); 
	QString data; 
	in >> data; 
	qDebug() << "New data: " << data;
}


//////////////////////////////////////////////////////////////////////////
// Called by the ComponentManager to stop the component
//////////////////////////////////////////////////////////////////////////
void TelnetClient::stopActivity()
{
	socket_->close();
	delete socket_;
}
