/*********************************************************************
//  created:    2016/05/13
//  filename:   StringGenerator.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 7253
//
//  version:    $Id: $
//
//  purpose:    A component that generates a string
//
*********************************************************************/

#include "Pacpus/kernel/Log.h"
#include "Pacpus/kernel/ComponentBase.h"
#include "Pacpus/kernel/ComponentFactory.h"

// Export macro for PacpusSocket DLL for Windows only
#ifdef WIN32
#   ifdef PACPUSSOCKET_EXPORTS
        // make DLL
#       define PACPUSSOCKET_API __declspec(dllexport)
#   else
        // use DLL
#       define PACPUSSOCKET_API __declspec(dllimport)
#   endif
#else
    // On other platforms, simply ignore this
#   define PACPUSSOCKET_API
#endif

namespace pacpus {

class PACPUSSOCKET_API StringGenerator
        : public QObject
        , public ComponentBase
{
  Q_OBJECT

public:
    /// Constructor
    StringGenerator(QString name);

    /// Destructor
    ~StringGenerator();

protected:
    // The 3 virtual methods relative to the ComponentBase inheritance
    virtual void startActivity();
    virtual void stopActivity();
    virtual COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

    virtual void addInputs();
    virtual void addOutputs();

private:
    OutputInterface<QString, StringGenerator>* stringOutput_;

};

} // namespace pacpus
