/*********************************************************************
//  created:    2016/05/13
//  filename:   StringGenerator.cpp
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 7253
//
//  version:    $Id: $
//
//  purpose:    A component that generates a string
//
*********************************************************************/

#include "StringGenerator.h"

using namespace pacpus;


DECLARE_STATIC_LOGGER("pacpusensors.StringGenerator");


//////////////////////////////////////////////////////////////////////////
// Construct the factory
//////////////////////////////////////////////////////////////////////////
static ComponentFactory <StringGenerator> sFactory("StringGenerator");


//////////////////////////////////////////////////////////////////////////
// Constructeur
//////////////////////////////////////////////////////////////////////////
StringGenerator::StringGenerator(QString name)
    : ComponentBase(name)
{
}


//////////////////////////////////////////////////////////////////////////
// Destructor
//////////////////////////////////////////////////////////////////////////
StringGenerator::~StringGenerator()
{
}


////////////////////////////////////////////////////////////////////////////////
// AddOutputs
////////////////////////////////////////////////////////////////////////////////
void StringGenerator::addOutputs()
{
	addOutput<QString, StringGenerator>("string");
}


////////////////////////////////////////////////////////////////////////////////
// AddInputs
////////////////////////////////////////////////////////////////////////////////
void StringGenerator::addInputs()
{
}


//////////////////////////////////////////////////////////////////////////
// Called by the ComponentManager to pass the XML parameters to the
// component
//////////////////////////////////////////////////////////////////////////
ComponentBase::COMPONENT_CONFIGURATION  StringGenerator::configureComponent(XmlComponentConfig config)
{

	return ComponentBase::CONFIGURED_OK;
}


//////////////////////////////////////////////////////////////////////////
// Called by the ComponentManager to start the component
//////////////////////////////////////////////////////////////////////////
void StringGenerator::startActivity()
{

    stringOutput_ = getTypedOutput<QString, StringGenerator>("string");
}


//////////////////////////////////////////////////////////////////////////
// Called by the ComponentManager to stop the component
//////////////////////////////////////////////////////////////////////////
void StringGenerator::stopActivity()
{

}
